/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.odbc;

import ec.tss.TsAsyncMode;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.IFileLoader;
import ec.tss.tsproviders.db.DbAccessor;
import ec.tss.tsproviders.jdbc.ConnectionSupplier;
import ec.tss.tsproviders.jdbc.JdbcAccessor;
import ec.tss.tsproviders.jdbc.JdbcBean;
import ec.tss.tsproviders.jdbc.JdbcProvider;
import ec.tss.tsproviders.odbc.OdbcBean;
import ec.tss.tsproviders.utils.IConstraint;
import ec.tss.tsproviders.utils.OptionalTsData;
import ec.tstoolkit.design.VisibleForTesting;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import nbbrd.sql.odbc.OdbcConnectionSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdbcProvider
extends JdbcProvider<OdbcBean>
implements IFileLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(OdbcProvider.class);
    public static final String SOURCE = "ODBCPRVDR";
    static final String VERSION = "20111201";
    protected final ConnectionSupplier.DriverBasedSupplier connectionSupplier;

    public OdbcProvider() {
        this(new OdbcSupplier());
    }

    @VisibleForTesting
    OdbcProvider(ConnectionSupplier.DriverBasedSupplier connectionSupplier) {
        super(SOURCE, VERSION, LOGGER, TsAsyncMode.Once);
        this.connectionSupplier = connectionSupplier;
    }

    public boolean isAvailable() {
        return this.connectionSupplier.isDriverAvailable();
    }

    public String getDisplayName() {
        return "ODBC DSNs";
    }

    public String getDisplayName(DataSource dataSource) {
        OdbcBean bean = this.decodeBean(dataSource);
        String dsn = bean.isDsnLess() ? bean.getFile().getPath() : bean.getDbName();
        String options = TsFrequency.Undefined == bean.getFrequency() ? "" : OptionalTsData.Builder.toString((TsFrequency)bean.getFrequency(), (TsAggregationType)bean.getAggregationType());
        return String.format("%s ~ %s \u00bb %s %s", dsn, bean.getTableName(), bean.getValueColumn(), options);
    }

    protected DbAccessor<OdbcBean> loadFromBean(OdbcBean bean) throws Exception {
        return new JdbcAccessor(this.logger, (JdbcBean)bean, (ConnectionSupplier)this.connectionSupplier).memoize();
    }

    public OdbcBean newBean() {
        return new OdbcBean();
    }

    public OdbcBean decodeBean(DataSource dataSource) {
        return new OdbcBean(this.support.check(dataSource, new IConstraint[0]));
    }

    public String getFileDescription() {
        return "Access file";
    }

    public boolean accept(File pathname) {
        return OdbcBean.FILE_FILTERS.stream().anyMatch(o -> o.accept(pathname));
    }

    public File[] getPaths() {
        return this.support.getPaths();
    }

    public void setPaths(File[] paths) {
        this.support.setPaths(paths);
        this.clearCache();
    }

    public ConnectionSupplier.DriverBasedSupplier getConnectionSupplier() {
        return this.connectionSupplier;
    }

    private static final class OdbcSupplier
    extends ConnectionSupplier.DriverBasedSupplier {
        private final Optional<OdbcConnectionSupplier> odbc = OdbcConnectionSupplier.ofServiceLoader();

        private OdbcSupplier() {
        }

        public Connection getConnection(JdbcBean bean) throws SQLException {
            return this.odbc.isPresent() ? this.odbc.get().getConnection(bean.getDbName()) : super.getConnection(bean);
        }

        protected String getUrl(JdbcBean bean) {
            return "jdbc:odbc:" + bean.getDbName();
        }

        protected boolean loadDriver() {
            return true;
        }

        public boolean isDriverAvailable() {
            return this.odbc.isPresent();
        }
    }
}

