/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.odbc.registry;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import ec.tstoolkit.design.IntValue;
import java.util.List;
import java.util.regex.Pattern;

@Deprecated
public final class OdbcDriver {
    private final String name;
    private final ApiLevel apiLevel;
    private final ConnectFunctions connectFunctions;
    private final String driver;
    private final String driverOdbcVer;
    private final ImmutableList<String> fileExtns;
    private final FileUsage fileUsage;
    private final String setup;
    private final SqlLevel sqlLevel;
    private final int usageCount;

    public OdbcDriver(String name, ApiLevel apiLevel, ConnectFunctions connectFunctions, String driver, String driverOdbcVer, ImmutableList<String> fileExtns, FileUsage fileUsage, String setup, SqlLevel sqlLevel, int usageCount) {
        this.name = name;
        this.apiLevel = apiLevel;
        this.connectFunctions = connectFunctions;
        this.driver = driver;
        this.driverOdbcVer = driverOdbcVer;
        this.fileExtns = fileExtns;
        this.fileUsage = fileUsage;
        this.setup = setup;
        this.sqlLevel = sqlLevel;
        this.usageCount = usageCount;
    }

    public String getName() {
        return this.name;
    }

    public ApiLevel getApiLevel() {
        return this.apiLevel;
    }

    public ConnectFunctions getConnectFunctions() {
        return this.connectFunctions;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getDriverOdbcVer() {
        return this.driverOdbcVer;
    }

    public List<String> getFileExtns() {
        return this.fileExtns;
    }

    public FileUsage getFileUsage() {
        return this.fileUsage;
    }

    public String getSetup() {
        return this.setup;
    }

    public SqlLevel getSqlLevel() {
        return this.sqlLevel;
    }

    public int getUsageCount() {
        return this.usageCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("apiLevel", (Object)this.apiLevel).add("connectFunctions", (Object)this.connectFunctions).add("driver", (Object)this.driver).add("driverOdbcVer", (Object)this.driverOdbcVer).add("fileExtns", this.fileExtns).add("fileUsage", (Object)this.fileUsage).add("setup", (Object)this.setup).add("sqlLevel", (Object)this.sqlLevel).add("usageCount", this.usageCount).toString();
    }

    public static enum ApiLevel implements IntValue
    {
        NONE(0),
        LEVEL1(1),
        LEVEL2(2);

        final int value;

        private ApiLevel(int value) {
            this.value = value;
        }

        public int intValue() {
            return this.value;
        }
    }

    public static class ConnectFunctions {
        final boolean sqlConnect;
        final boolean sqlDriverConnect;
        final boolean sqlBrowseConnect;
        static final Pattern INPUT_PATTERN = Pattern.compile("(Y|N){3}");

        public ConnectFunctions(boolean sqlConnect, boolean sqlDriverConnect, boolean sqlBrowseConnect) {
            this.sqlConnect = sqlConnect;
            this.sqlDriverConnect = sqlDriverConnect;
            this.sqlBrowseConnect = sqlBrowseConnect;
        }

        public boolean isSqlConnect() {
            return this.sqlConnect;
        }

        public boolean isSqlDriverConnect() {
            return this.sqlDriverConnect;
        }

        public boolean isSqlBrowseConnect() {
            return this.sqlBrowseConnect;
        }

        public String toString() {
            return (this.sqlConnect ? "Y" : "N") + (this.sqlDriverConnect ? "Y" : "N") + (this.sqlBrowseConnect ? "Y" : "N");
        }

        public static ConnectFunctions valueOf(String input) {
            return input != null && INPUT_PATTERN.matcher(input).matches() ? new ConnectFunctions(input.charAt(0) == 'Y', input.charAt(1) == 'Y', input.charAt(2) == 'Y') : null;
        }
    }

    public static enum FileUsage implements IntValue
    {
        NONE(0),
        TABLE(1),
        CATALOG(2);

        final int value;

        private FileUsage(int value) {
            this.value = value;
        }

        public int intValue() {
            return this.value;
        }

        public boolean isFileBased() {
            return this != NONE;
        }
    }

    public static enum SqlLevel implements IntValue
    {
        SQL_92_ENTRY(0),
        FIPS127_2_TRANSACTIONAL(1),
        SQL_92_INTERMEDIATE(2),
        SQL_92_FULL(3);

        final int value;

        private SqlLevel(int value) {
            this.value = value;
        }

        public int intValue() {
            return this.value;
        }
    }
}

