/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.output;

import ec.satoolkit.ISaSpecification;
import ec.tss.Ts;
import ec.tss.sa.documents.SaDocument;
import ec.tss.sa.output.BasicConfiguration;
import ec.tss.sa.output.DefaultSummary;
import ec.tss.sa.output.SpreadsheetOutputConfiguration;
import ec.tss.sa.output.XSSFHelper;
import ec.tss.tsproviders.utils.MultiLineNameUtil;
import ec.tstoolkit.algorithm.IOutput;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataTable;
import ec.tstoolkit.utilities.NamedObject;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class SpreadsheetOutput
implements IOutput<SaDocument<ISaSpecification>> {
    SpreadsheetOutputConfiguration config_;
    List<DefaultSummary> summaries_ = new ArrayList<DefaultSummary>();
    File folder_;
    private boolean fullName;

    public SpreadsheetOutput(SpreadsheetOutputConfiguration config) {
        this.config_ = config.clone();
        this.fullName = this.config_.isFullName();
    }

    public void process(SaDocument<ISaSpecification> document) {
        DefaultSummary summary = new DefaultSummary(((Ts)document.getInput()).getRawName(), document.getResults(), this.config_.getSeries());
        if (this.config_.isSaveModel()) {
            summary.setModel((ISaSpecification)document.getSpecification());
        }
        this.summaries_.add(summary);
    }

    public void start(Object context) {
        this.summaries_.clear();
        this.folder_ = BasicConfiguration.folderFromContext((File)this.config_.getFolder(), (Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Object context) throws Exception {
        String file = this.folder_.toPath().resolve(this.config_.getFileName()).toFile().getAbsolutePath();
        file = ec.tstoolkit.utilities.Paths.changeExtension((String)file, (String)"xlsx");
        File ssfile = Paths.get(file, new String[0]).toFile();
        SXSSFWorkbook workbook = new SXSSFWorkbook(null, 100, false, true);
        try (OutputStream stream = Files.newOutputStream(ssfile.toPath(), new OpenOption[0]);){
            switch (this.config_.getLayout()) {
                case ByComponent: {
                    HashMap allData = new HashMap();
                    for (DefaultSummary defaultSummary : this.summaries_) {
                        for (Map.Entry keyValue : defaultSummary.getAllSeries().entrySet()) {
                            List<NamedObject> list = null;
                            if (!allData.containsKey(keyValue.getKey())) {
                                list = new ArrayList();
                                allData.put((String)keyValue.getKey(), list);
                            } else {
                                list = (List)allData.get(keyValue.getKey());
                            }
                            String name = this.fullName ? MultiLineNameUtil.join((String)defaultSummary.getName(), (String)" * ") : MultiLineNameUtil.last((String)defaultSummary.getName());
                            list.add(new NamedObject(name, (Object)((TsData)keyValue.getValue())));
                        }
                    }
                    for (Map.Entry entry : allData.entrySet()) {
                        TsDataTable byComponentTable = new TsDataTable();
                        List value = (List)entry.getValue();
                        String[] headers = new String[value.size()];
                        for (int i = 0; i < headers.length; ++i) {
                            NamedObject data = (NamedObject)value.get(i);
                            headers[i] = data.name;
                            byComponentTable.insert(-1, (TsData)data.object);
                        }
                        XSSFHelper.addSheet((Workbook)workbook, (String)entry.getKey(), new String[]{(String)entry.getKey()}, headers, byComponentTable, this.config_.isVerticalOrientation());
                    }
                    break;
                }
                case BySeries: {
                    for (int i = 0; i < this.summaries_.size(); ++i) {
                        DefaultSummary summary = this.summaries_.get(i);
                        Set set = summary.getAllSeries().entrySet();
                        TsDataTable bySeriesTable = new TsDataTable();
                        String[] componentHeaders = new String[set.size()];
                        int j = 0;
                        for (Map.Entry keyValue : set) {
                            componentHeaders[j++] = (String)keyValue.getKey();
                            bySeriesTable.insert(-1, (TsData)keyValue.getValue());
                        }
                        String name = this.fullName ? MultiLineNameUtil.join((String)summary.getName(), (String)" * ") : MultiLineNameUtil.last((String)summary.getName());
                        XSSFHelper.addSheet((Workbook)workbook, "Series" + Integer.toString(i), new String[]{name}, componentHeaders, bySeriesTable, this.config_.isVerticalOrientation());
                    }
                    break;
                }
                case OneSheet: {
                    ArrayList<String> headers0 = new ArrayList<String>();
                    ArrayList<String> headers1 = new ArrayList<String>();
                    TsDataTable tsDataTable = new TsDataTable();
                    for (DefaultSummary summary : this.summaries_) {
                        String name = this.fullName ? MultiLineNameUtil.join((String)summary.getName(), (String)" * ") : MultiLineNameUtil.last((String)summary.getName());
                        headers0.add(name);
                        Map data = summary.getAllSeries();
                        for (Map.Entry keyValue : data.entrySet()) {
                            headers1.add((String)keyValue.getKey());
                            tsDataTable.insert(-1, (TsData)keyValue.getValue());
                        }
                        for (int i = 1; i < data.size(); ++i) {
                            headers0.add("");
                        }
                    }
                    XSSFHelper.addSheet((Workbook)workbook, "Series", (String[])headers0.stream().toArray(String[]::new), (String[])headers1.stream().toArray(String[]::new), tsDataTable, this.config_.isVerticalOrientation());
                    break;
                }
            }
            workbook.write(stream);
        }
        finally {
            workbook.dispose();
        }
    }

    public String getName() {
        return "Spreadsheet";
    }

    public boolean isAvailable() {
        return true;
    }
}

