/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.spreadsheet;

import com.google.common.collect.ImmutableList;
import ec.tss.tsproviders.spreadsheet.SpreadSheetBean;
import ec.tss.tsproviders.spreadsheet.engine.SpreadSheetSource;
import ec.tss.tsproviders.spreadsheet.facade.Book;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ServiceLoader;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Deprecated
public final class SpreadSheetAccessor
implements FileFilter {
    public static final SpreadSheetAccessor INSTANCE = new SpreadSheetAccessor();
    private ImmutableList<Book.Factory> factories = null;

    private SpreadSheetAccessor() {
    }

    public synchronized ImmutableList<Book.Factory> getFactories() {
        if (this.factories == null) {
            this.factories = ImmutableList.copyOf(ServiceLoader.load(Book.Factory.class));
        }
        return this.factories;
    }

    public synchronized void setFactories(ImmutableList<Book.Factory> factories) {
        this.factories = factories;
    }

    private @Nullable Book.Factory getFactoryByFile(@NonNull File file) {
        for (Book.Factory o : this.getFactories()) {
            if (!o.canLoad() || !o.accept(file)) continue;
            return o;
        }
        return null;
    }

    @Override
    public boolean accept(File file) {
        return this.getFactoryByFile(file) != null;
    }

    public @NonNull SpreadSheetSource load(@NonNull File file, @NonNull SpreadSheetBean bean) throws IOException {
        Book.Factory factory = this.getFactoryByFile(file);
        if (factory != null) {
            try (Book book = factory.load(file);){
                SpreadSheetSource spreadSheetSource = SpreadSheetSource.load(book, bean.getDataFormat(), bean.getFrequency(), bean.getAggregationType(), bean.isCleanMissing());
                return spreadSheetSource;
            }
        }
        throw new RuntimeException("File type not supported");
    }
}

