/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.spreadsheet;

import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.IDataSourceBean;
import ec.tss.tsproviders.IFileBean;
import ec.tss.tsproviders.utils.DataFormat;
import ec.tss.tsproviders.utils.IConfig;
import ec.tss.tsproviders.utils.IParam;
import ec.tss.tsproviders.utils.Params;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.io.File;
import java.nio.file.Paths;

public class SpreadSheetBean
implements IFileBean,
IDataSourceBean {
    static final IParam<DataSource, File> X_FILE = Params.onFile((File)Paths.get("", new String[0]).toFile(), (String)"file");
    static final IParam<DataSource, DataFormat> X_DATAFORMAT = Params.onDataFormat((DataFormat)DataFormat.DEFAULT, (String)"locale", (String)"datePattern", (String)"numberPattern");
    static final IParam<DataSource, TsFrequency> X_FREQUENCY = Params.onEnum((Enum)TsFrequency.Undefined, (String)"frequency");
    static final IParam<DataSource, TsAggregationType> X_AGGREGATION_TYPE = Params.onEnum((Enum)TsAggregationType.None, (String)"aggregationType");
    static final IParam<DataSource, Boolean> X_CLEAN_MISSING = Params.onBoolean((Boolean)true, (String)"cleanMissing");
    File file;
    DataFormat dataFormat;
    TsFrequency frequency;
    TsAggregationType aggregationType;
    boolean cleanMissing;

    public SpreadSheetBean() {
        this.file = (File)X_FILE.defaultValue();
        this.dataFormat = (DataFormat)X_DATAFORMAT.defaultValue();
        this.frequency = (TsFrequency)X_FREQUENCY.defaultValue();
        this.aggregationType = (TsAggregationType)X_AGGREGATION_TYPE.defaultValue();
        this.cleanMissing = (Boolean)X_CLEAN_MISSING.defaultValue();
    }

    public SpreadSheetBean(DataSource dataSource) {
        this.file = (File)X_FILE.get((IConfig)dataSource);
        this.dataFormat = (DataFormat)X_DATAFORMAT.get((IConfig)dataSource);
        this.frequency = (TsFrequency)X_FREQUENCY.get((IConfig)dataSource);
        this.aggregationType = (TsAggregationType)X_AGGREGATION_TYPE.get((IConfig)dataSource);
        this.cleanMissing = (Boolean)X_CLEAN_MISSING.get((IConfig)dataSource);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public TsFrequency getFrequency() {
        return this.frequency;
    }

    public void setFrequency(TsFrequency frequency) {
        this.frequency = frequency;
    }

    public TsAggregationType getAggregationType() {
        return this.aggregationType;
    }

    public void setAggregationType(TsAggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public boolean isCleanMissing() {
        return this.cleanMissing;
    }

    public void setCleanMissing(boolean clean) {
        this.cleanMissing = clean;
    }

    public DataSource toDataSource(String providerName, String version) {
        DataSource.Builder builder = DataSource.builder((String)providerName, (String)version);
        X_FILE.set((IConfig.Builder)builder, (Object)this.file);
        X_DATAFORMAT.set((IConfig.Builder)builder, (Object)this.dataFormat);
        X_FREQUENCY.set((IConfig.Builder)builder, (Object)this.frequency);
        X_AGGREGATION_TYPE.set((IConfig.Builder)builder, (Object)this.aggregationType);
        X_CLEAN_MISSING.set((IConfig.Builder)builder, (Object)this.cleanMissing);
        return builder.build();
    }

    @Deprecated
    public DataSource toDataSource() {
        return this.toDataSource("XCLPRVDR", "20111201");
    }

    @Deprecated
    public static SpreadSheetBean from(DataSource dataSource) {
        return new SpreadSheetBean(dataSource);
    }
}

