/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.spreadsheet;

import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.IFileBean;
import ec.tss.tsproviders.TsProviders;
import ec.tss.tsproviders.legacy.FileDataSourceId;
import ec.tss.tsproviders.legacy.InvalidMonikerException;
import ec.tss.tsproviders.spreadsheet.SpreadSheetBean;
import ec.tss.tsproviders.spreadsheet.SpreadSheetProvider;
import ec.tss.tsproviders.spreadsheet.engine.SpreadSheetCollection;
import ec.tss.tsproviders.spreadsheet.engine.SpreadSheetSeries;
import ec.tss.tsproviders.spreadsheet.engine.SpreadSheetSource;
import ec.tss.tsproviders.utils.Parsers;
import org.checkerframework.checker.nullness.qual.NonNull;

final class SpreadSheetLegacy {
    private SpreadSheetLegacy() {
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parsers.Parser<DataSource> legacyDataSourceParser() {
        return new Parsers.Parser<DataSource>(){

            public DataSource parse(CharSequence input) throws NullPointerException {
                FileDataSourceId id = FileDataSourceId.parse((CharSequence)input);
                return id != null ? SpreadSheetLegacy.newDataSource(id) : null;
            }
        };
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parsers.Parser<DataSet> legacyDataSetParser() {
        final Parsers.Parser<DataSource> tmp = SpreadSheetLegacy.legacyDataSourceParser();
        return new Parsers.FailSafeParser<DataSet>(){

            protected DataSet doParse(CharSequence input) throws Exception {
                SpreadSheetId id = SpreadSheetId.parse(input.toString());
                DataSource dataSource = (DataSource)tmp.parse((CharSequence)id.getFileName());
                if (dataSource == null) {
                    return null;
                }
                if (id.isCollection()) {
                    return ((DataSet.Builder)DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.COLLECTION).put(SpreadSheetProvider.Y_SHEETNAME, (Object)id.getSheetName())).build();
                }
                String seriesName = SpreadSheetLegacy.searchSeriesName(dataSource, id);
                return ((DataSet.Builder)((DataSet.Builder)DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.SERIES).put(SpreadSheetProvider.Y_SHEETNAME, (Object)id.getSheetName())).put(SpreadSheetProvider.Z_SERIESNAME, (Object)seriesName)).build();
            }
        };
    }

    private static DataSource newDataSource(FileDataSourceId id) {
        return ((SpreadSheetBean)id.fill((IFileBean)new SpreadSheetBean())).toDataSource("XCLPRVDR", "20111201");
    }

    private static String searchSeriesName(DataSource dataSource, SpreadSheetId id) {
        int sid = id.getIndexSeries();
        if (sid >= 0) {
            return SeriesNameResolver.INSTANCE.resolveName(dataSource, id.getSheetName(), id.getIndexSeries());
        }
        return id.getSeriesName();
    }

    private static final class SpreadSheetId {
        public static final String BSEP = "<<";
        public static final String ESEP = ">>";
        private String shortFile_;
        private String sheetName_;
        private String seriesName_;
        private int indexSeries_ = -1;

        private SpreadSheetId() {
        }

        public String getFileName() {
            return this.shortFile_;
        }

        public String getSheetName() {
            return this.sheetName_;
        }

        public int getIndexSeries() {
            return this.indexSeries_;
        }

        public String getSeriesName() {
            return this.seriesName_;
        }

        public static SpreadSheetId collection(String sfile, String name) {
            SpreadSheetId id = new SpreadSheetId();
            id.shortFile_ = sfile;
            id.sheetName_ = name;
            return id;
        }

        public static SpreadSheetId series(String sfile, String sheetName, int spos) {
            SpreadSheetId id = new SpreadSheetId();
            id.shortFile_ = sfile;
            id.sheetName_ = sheetName;
            id.indexSeries_ = spos;
            return id;
        }

        public static SpreadSheetId series(String sfile, String sheetName, String sname) {
            SpreadSheetId id = new SpreadSheetId();
            id.shortFile_ = sfile;
            id.sheetName_ = sheetName;
            id.seriesName_ = sname;
            return id;
        }

        public static SpreadSheetId parse(String monikerId) throws InvalidMonikerException {
            int beg = monikerId.indexOf(BSEP);
            if (beg != 0) {
                throw new InvalidMonikerException(monikerId);
            }
            int end = monikerId.indexOf(ESEP, beg += BSEP.length());
            if (end < 0) {
                throw new InvalidMonikerException(monikerId);
            }
            String fname = monikerId.substring(beg, end);
            beg = end + ESEP.length();
            if ((beg = monikerId.indexOf(BSEP, beg)) < 0) {
                throw new InvalidMonikerException(monikerId);
            }
            end = monikerId.indexOf(ESEP, beg += BSEP.length());
            if (end < 0) {
                throw new InvalidMonikerException(monikerId);
            }
            String sheetname = monikerId.substring(beg, end);
            beg = end + ESEP.length();
            if (beg < monikerId.length()) {
                if ((beg = monikerId.indexOf(BSEP, beg)) < 0) {
                    throw new InvalidMonikerException(monikerId);
                }
                end = monikerId.indexOf(ESEP, beg += BSEP.length());
                if (end < 0) {
                    throw new InvalidMonikerException();
                }
                String s = monikerId.substring(beg, end);
                try {
                    short sid = Short.parseShort(s);
                    return SpreadSheetId.series(fname, sheetname, sid);
                }
                catch (NumberFormatException numberFormatException) {
                    return SpreadSheetId.series(fname, sheetname, s);
                }
            }
            return SpreadSheetId.collection(fname, sheetname);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(BSEP).append(this.shortFile_).append(ESEP).append(BSEP).append(this.sheetName_).append(ESEP);
            if (this.isSeries()) {
                if (this.indexSeries_ >= 0) {
                    builder.append(BSEP).append(this.indexSeries_).append(ESEP);
                } else {
                    builder.append(BSEP).append(this.seriesName_).append(ESEP);
                }
            }
            return builder.toString();
        }

        public boolean isCollection() {
            return -1 == this.indexSeries_ && this.seriesName_ == null;
        }

        public boolean isSeries() {
            return this.indexSeries_ >= 0 || this.seriesName_ != null;
        }
    }

    private static enum SeriesNameResolver {
        INSTANCE;


        public String resolveName(DataSource dataSource, String sheetName, int index) {
            SpreadSheetSource col;
            SpreadSheetProvider tmp = (SpreadSheetProvider)((Object)TsProviders.lookup(SpreadSheetProvider.class, (DataSource)dataSource).get());
            try {
                col = tmp.getSource(dataSource);
            }
            catch (Exception ex) {
                return null;
            }
            SpreadSheetCollection cur = SpreadSheetProvider.search(col, sheetName);
            if (cur == null) {
                return null;
            }
            return index < cur.series.size() ? ((SpreadSheetSeries)cur.series.get((int)index)).seriesName : null;
        }
    }
}

