/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.spreadsheet;

import ec.tss.TsAsyncMode;
import ec.tss.TsCollectionInformation;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.spreadsheet.SpreadSheetBean;
import ec.tss.tsproviders.spreadsheet.SpreadSheetLegacy;
import ec.tss.tsproviders.spreadsheet.engine.SpreadSheetCollection;
import ec.tss.tsproviders.spreadsheet.engine.SpreadSheetFactory;
import ec.tss.tsproviders.spreadsheet.engine.SpreadSheetSeries;
import ec.tss.tsproviders.spreadsheet.engine.SpreadSheetSource;
import ec.tss.tsproviders.spreadsheet.engine.TsImportOptions;
import ec.tss.tsproviders.utils.AbstractFileLoader;
import ec.tss.tsproviders.utils.IConfig;
import ec.tss.tsproviders.utils.IConstraint;
import ec.tss.tsproviders.utils.IParam;
import ec.tss.tsproviders.utils.ObsGathering;
import ec.tss.tsproviders.utils.OptionalTsData;
import ec.tss.tsproviders.utils.Params;
import ec.tss.tsproviders.utils.Parsers;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.util.spreadsheet.Book;
import internal.ec.tss.tsproviders.spreadsheet.BookSupplier;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpreadSheetProvider
extends AbstractFileLoader<SpreadSheetSource, SpreadSheetBean> {
    public static final String SOURCE = "XCLPRVDR";
    public static final String VERSION = "20111201";
    public static final IParam<DataSet, String> Y_SHEETNAME = Params.onString((String)"", (String)"sheetName");
    public static final IParam<DataSet, String> Z_SERIESNAME = Params.onString((String)"", (String)"seriesName");
    private static final Logger LOGGER = LoggerFactory.getLogger(SpreadSheetProvider.class);
    protected final Parsers.Parser<DataSource> legacyDataSourceParser = SpreadSheetLegacy.legacyDataSourceParser();
    protected final Parsers.Parser<DataSet> legacyDataSetParser = SpreadSheetLegacy.legacyDataSetParser();
    private final BookSupplier bookSupplier = BookSupplier.usingServiceLoader();

    public SpreadSheetProvider() {
        super(LOGGER, SOURCE, TsAsyncMode.Once);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet toDataSet(TsMoniker moniker) throws IllegalArgumentException {
        DataSet result = super.toDataSet(moniker);
        if (result != null) {
            return result;
        }
        Parsers.Parser<DataSet> parser = this.legacyDataSetParser;
        synchronized (parser) {
            return (DataSet)this.legacyDataSetParser.parse((CharSequence)moniker.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource toDataSource(TsMoniker moniker) throws IllegalArgumentException {
        DataSource result = super.toDataSource(moniker);
        if (result != null) {
            return result;
        }
        Parsers.Parser<DataSource> parser = this.legacyDataSourceParser;
        synchronized (parser) {
            return (DataSource)this.legacyDataSourceParser.parse((CharSequence)moniker.getId());
        }
    }

    protected SpreadSheetSource loadFromBean(SpreadSheetBean bean) throws Exception {
        File file = this.getRealFile(bean.getFile());
        Book.Factory factory = this.bookSupplier.getFactory(file).orElseThrow(() -> new RuntimeException("File type not supported"));
        try (Book book = factory.load(file);){
            ObsGathering gathering = bean.isCleanMissing() ? ObsGathering.excludingMissingValues((TsFrequency)bean.getFrequency(), (TsAggregationType)bean.getAggregationType()) : ObsGathering.includingMissingValues((TsFrequency)bean.getFrequency(), (TsAggregationType)bean.getAggregationType());
            TsImportOptions options = TsImportOptions.create(bean.getDataFormat(), gathering);
            SpreadSheetSource spreadSheetSource = SpreadSheetFactory.getDefault().toSource(book, options);
            return spreadSheetSource;
        }
    }

    public String getDisplayName() {
        return "Spreadsheets";
    }

    public String getDisplayName(DataSource dataSource) {
        SpreadSheetBean bean = this.decodeBean(dataSource);
        return TsFrequency.Undefined != bean.getFrequency() ? bean.getFile().getPath() + " " + OptionalTsData.Builder.toString((TsFrequency)bean.getFrequency(), (TsAggregationType)bean.getAggregationType()) : bean.getFile().getPath();
    }

    public String getDisplayName(DataSet dataSet) {
        this.support.check(dataSet, new IConstraint[0]);
        switch (dataSet.getKind()) {
            case COLLECTION: {
                return (String)Y_SHEETNAME.get((IConfig)dataSet);
            }
            case SERIES: {
                return (String)Y_SHEETNAME.get((IConfig)dataSet) + "\n" + (String)Z_SERIESNAME.get((IConfig)dataSet);
            }
        }
        throw new IllegalArgumentException(dataSet.getKind().name());
    }

    public List<DataSet> children(DataSource dataSource) throws IOException {
        this.support.check(dataSource, new IConstraint[0]);
        SpreadSheetSource ws = this.getSource(dataSource);
        if (ws.collections.isEmpty()) {
            return Collections.emptyList();
        }
        DataSet.Builder builder = DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.COLLECTION);
        return ws.collections.values().stream().sorted().map(o -> ((DataSet.Builder)builder.put(Y_SHEETNAME, (Object)o.sheetName)).build()).collect(Collectors.toList());
    }

    public String getDisplayNodeName(DataSet dataSet) {
        this.support.check(dataSet, new IConstraint[0]);
        switch (dataSet.getKind()) {
            case COLLECTION: {
                return (String)Y_SHEETNAME.get((IConfig)dataSet);
            }
            case SERIES: {
                return (String)Z_SERIESNAME.get((IConfig)dataSet);
            }
        }
        throw new IllegalArgumentException(dataSet.getKind().name());
    }

    public List<DataSet> children(DataSet parent) throws IOException {
        this.support.check(parent, new IConstraint[]{DataSet.Kind.COLLECTION});
        SpreadSheetCollection col = this.getCollection(parent);
        if (col == null || col.series.isEmpty()) {
            return Collections.emptyList();
        }
        DataSet.Builder builder = parent.toBuilder(DataSet.Kind.SERIES);
        return col.series.stream().sorted().map(o -> ((DataSet.Builder)builder.put(Z_SERIESNAME, (Object)o.seriesName)).build()).collect(Collectors.toList());
    }

    protected void fillCollection(TsCollectionInformation info, DataSource dataSource) throws IOException {
        SpreadSheetSource source = this.getSource(dataSource);
        info.type = TsInformationType.All;
        DataSet.Builder builder = DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.COLLECTION);
        source.collections.values().stream().sorted().forEach(o -> {
            DataSet child = ((DataSet.Builder)builder.put(Y_SHEETNAME, (Object)o.sheetName)).build();
            info.items.addAll(this.getAll(child, (SpreadSheetCollection)o));
        });
    }

    protected void fillCollection(TsCollectionInformation info, DataSet dataSet) throws IOException {
        SpreadSheetCollection collection = this.getCollection(dataSet);
        if (collection == null) {
            throw new IOException("null");
        }
        info.name = collection.sheetName;
        info.type = TsInformationType.All;
        info.items.addAll(this.getAll(dataSet, collection));
    }

    List<TsInformation> getAll(DataSet dataSet, SpreadSheetCollection collection) {
        if (collection.series.isEmpty()) {
            return Collections.emptyList();
        }
        DataSet.Builder builder = dataSet.toBuilder(DataSet.Kind.SERIES);
        return collection.series.stream().map(o -> {
            DataSet child = ((DataSet.Builder)builder.put(Z_SERIESNAME, (Object)o.seriesName)).build();
            return this.support.fillSeries(this.newTsInformation(child, TsInformationType.All), o.data, ((Boolean)SpreadSheetBean.X_CLEAN_MISSING.get((IConfig)dataSet.getDataSource())).booleanValue());
        }).collect(Collectors.toList());
    }

    protected void fillSeries(TsInformation info, DataSet dataSet) throws IOException {
        SpreadSheetSeries series = this.getSeries(dataSet);
        if (series == null) {
            throw new IOException("null");
        }
        this.support.fillSeries(info, series.data, ((Boolean)SpreadSheetBean.X_CLEAN_MISSING.get((IConfig)dataSet.getDataSource())).booleanValue());
        info.name = this.getDisplayName(dataSet);
        info.type = TsInformationType.All;
    }

    public @NonNull SpreadSheetSource getSource(DataSource dataSource) throws IOException {
        return (SpreadSheetSource)this.support.getValue(this.cache, dataSource);
    }

    public SpreadSheetCollection getCollection(DataSet dataSet) throws IOException {
        SpreadSheetSource ws = this.getSource(dataSet.getDataSource());
        return SpreadSheetProvider.search(ws, (String)Y_SHEETNAME.get((IConfig)dataSet));
    }

    public SpreadSheetSeries getSeries(DataSet dataSet) throws IOException {
        SpreadSheetCollection worksheet = this.getCollection(dataSet);
        if (worksheet == null) {
            return null;
        }
        String s = (String)Z_SERIESNAME.get((IConfig)dataSet);
        for (SpreadSheetSeries o : worksheet.series) {
            if (!o.seriesName.equals(s)) continue;
            return o;
        }
        s = SpreadSheetProvider.clean(s);
        for (SpreadSheetSeries o : worksheet.series) {
            if (!o.seriesName.equals(s)) continue;
            return o;
        }
        return null;
    }

    static SpreadSheetCollection search(SpreadSheetSource ws, String cname) {
        if (ws == null) {
            return null;
        }
        return (SpreadSheetCollection)ws.collections.get((Object)SpreadSheetProvider.clean(cname));
    }

    private static String clean(String s) {
        int l = s.lastIndexOf(36);
        if (l < 0) {
            return s;
        }
        if ((s = s.substring(0, l)).charAt(0) == '\'') {
            s = s.substring(1);
        }
        return s.replace('#', '.');
    }

    public SpreadSheetBean newBean() {
        return new SpreadSheetBean();
    }

    public DataSource encodeBean(Object bean) throws IllegalArgumentException {
        try {
            return ((SpreadSheetBean)bean).toDataSource(SOURCE, VERSION);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public SpreadSheetBean decodeBean(DataSource dataSource) {
        return new SpreadSheetBean(this.support.check(dataSource, new IConstraint[0]));
    }

    public boolean accept(File pathname) {
        return this.bookSupplier.getFactory(pathname).isPresent();
    }

    public String getFileDescription() {
        return "Spreadsheet file";
    }
}

