/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.spreadsheet.engine;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import ec.tss.tsproviders.spreadsheet.facade.Cell;
import ec.tss.tsproviders.spreadsheet.facade.Sheet;
import ec.tss.tsproviders.utils.IParser;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Deprecated
public abstract class CellParser<T> {
    public abstract @Nullable T parse(@NonNull Sheet var1, int var2, int var3);

    public @NonNull Optional<T> tryParse(@NonNull Sheet sheet, int rowIndex, int columnIndex) {
        return Optional.fromNullable(this.parse(sheet, rowIndex, columnIndex));
    }

    public @NonNull CellParser<T> or(CellParser<T> ... cellParser) {
        switch (cellParser.length) {
            case 0: {
                return this;
            }
            case 1: {
                return CellParser.firstNotNull(ImmutableList.of((Object)this, cellParser[0]));
            }
        }
        return CellParser.firstNotNull(ImmutableList.builder().add((Object)this).add((Object[])cellParser).build());
    }

    public static <X> @NonNull CellParser<X> firstNotNull(@NonNull ImmutableList<? extends CellParser<X>> list) {
        return new FirstNotNull(list);
    }

    public static <X> @NonNull CellParser<X> fromParser(@NonNull IParser<X> parser) {
        return new Adapter<X>(parser);
    }

    public static @NonNull CellParser<Date> onDateType() {
        return DateCellFunc.INSTANCE;
    }

    public static @NonNull CellParser<Number> onNumberType() {
        return NumberCellFunc.INSTANCE;
    }

    public static @NonNull CellParser<String> onStringType() {
        return StringCellFunc.INSTANCE;
    }

    private static final class FirstNotNull<X>
    extends CellParser<X> {
        private final ImmutableList<? extends CellParser<X>> list;

        FirstNotNull(ImmutableList<? extends CellParser<X>> list) {
            this.list = list;
        }

        @Override
        public X parse(Sheet sheet, int rowIndex, int columnIndex) {
            for (CellParser o : this.list) {
                Object result = o.parse(sheet, rowIndex, columnIndex);
                if (result == null) continue;
                return (X)result;
            }
            return null;
        }
    }

    private static final class Adapter<X>
    extends CellParser<X> {
        private final IParser<X> adaptee;

        Adapter(IParser<X> parser) {
            this.adaptee = parser;
        }

        @Override
        public X parse(Sheet sheet, int rowIndex, int columnIndex) {
            String input = StringCellFunc.INSTANCE.parse(sheet, rowIndex, columnIndex);
            return (X)(input != null ? this.adaptee.parse((CharSequence)input) : null);
        }
    }

    private static final class DateCellFunc
    extends CellParser<Date> {
        static final DateCellFunc INSTANCE = new DateCellFunc();

        private DateCellFunc() {
        }

        @Override
        public Date parse(Sheet sheet, int rowIndex, int columnIndex) {
            Cell cell = sheet.getCell(rowIndex, columnIndex);
            return cell != null && cell.isDate() ? cell.getDate() : null;
        }
    }

    private static final class NumberCellFunc
    extends CellParser<Number> {
        static final NumberCellFunc INSTANCE = new NumberCellFunc();

        private NumberCellFunc() {
        }

        @Override
        public Number parse(Sheet sheet, int rowIndex, int columnIndex) {
            Cell cell = sheet.getCell(rowIndex, columnIndex);
            return cell != null && cell.isNumber() ? (Number)cell.getNumber() : (Number)null;
        }
    }

    private static final class StringCellFunc
    extends CellParser<String> {
        static final StringCellFunc INSTANCE = new StringCellFunc();

        private StringCellFunc() {
        }

        @Override
        public String parse(Sheet sheet, int rowIndex, int columnIndex) {
            Cell cell = sheet.getCell(rowIndex, columnIndex);
            return cell != null && cell.isString() ? cell.getString() : null;
        }
    }
}

