/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.spreadsheet.engine;

import com.google.common.collect.ImmutableList;
import ec.tss.tsproviders.spreadsheet.engine.CellParser;
import ec.tss.tsproviders.spreadsheet.engine.SpreadSheetCollection;
import ec.tss.tsproviders.spreadsheet.engine.SpreadSheetSeries;
import ec.tss.tsproviders.spreadsheet.engine.SpreadSheetSource;
import ec.tss.tsproviders.spreadsheet.facade.Book;
import ec.tss.tsproviders.spreadsheet.facade.Sheet;
import ec.tss.tsproviders.utils.DataFormat;
import ec.tss.tsproviders.utils.IParser;
import ec.tss.tsproviders.utils.ObsCharacteristics;
import ec.tss.tsproviders.utils.ObsGathering;
import ec.tss.tsproviders.utils.OptionalTsData;
import ec.tstoolkit.design.VisibleForTesting;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

@Deprecated
abstract class Engine {
    private static final int FIRST_DATA_ROW_IDX = 1;
    private static final int FIRST_DATA_COL_IDX = 1;
    private static final int DATE_COL_IDX = 0;
    private static final int NAME_ROW_IDX = 0;

    Engine() {
    }

    @VisibleForTesting
    static SpreadSheetSource parseSource(Book book, DataFormat df, TsFrequency freq, TsAggregationType aggregation, boolean clean) throws IOException {
        return Engine.parseSource(book, (IParser<Date>)df.dateParser(), (IParser<Number>)df.numberParser(), freq, aggregation, clean);
    }

    @VisibleForTesting
    static SpreadSheetSource parseSource(Book book, IParser<Date> dateParser, IParser<Number> numberParser, TsFrequency freq, TsAggregationType aggregation, boolean clean) throws IOException {
        CellParser<String> toName = CellParser.onStringType();
        CellParser<Date> toDate = CellParser.onDateType().or(CellParser.fromParser(dateParser));
        CellParser<Number> toNumber = CellParser.onNumberType().or(CellParser.fromParser(numberParser));
        return Engine.parseSource(book, toName, toDate, toNumber, freq, aggregation, clean);
    }

    @VisibleForTesting
    static SpreadSheetSource parseSource(Book book, CellParser<String> toName, CellParser<Date> toDate, CellParser<Number> toNumber, TsFrequency frequency, TsAggregationType aggregationType, boolean clean) throws IOException {
        int sheetCount = book.getSheetCount();
        SpreadSheetCollection[] result = new SpreadSheetCollection[sheetCount];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Engine.parseCollection(book.getSheet(i), i, toName, toDate, toNumber, frequency, aggregationType, clean);
        }
        return new SpreadSheetSource(Arrays.asList(result), book.getFactoryName());
    }

    @VisibleForTesting
    static SpreadSheetCollection parseCollection(Sheet sheet, int ordering, CellParser<String> toName, CellParser<Date> toDate, CellParser<Number> toNumber, TsFrequency frequency, TsAggregationType aggregationType, boolean clean) {
        switch (Engine.parseAlignType(sheet, toName, toDate)) {
            case VERTICAL: {
                return Engine.loadVertically(SpreadSheetCollection.AlignType.VERTICAL, ordering, sheet, toName, toDate, toNumber, frequency, aggregationType, clean);
            }
            case HORIZONTAL: {
                return Engine.loadVertically(SpreadSheetCollection.AlignType.HORIZONTAL, ordering, sheet.inv(), toName, toDate, toNumber, frequency, aggregationType, clean);
            }
            case UNKNOWN: {
                return new SpreadSheetCollection(sheet.getName(), ordering, SpreadSheetCollection.AlignType.UNKNOWN, (ImmutableList<SpreadSheetSeries>)ImmutableList.of());
            }
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @VisibleForTesting
    static SpreadSheetCollection.AlignType parseAlignType(Sheet sheet, CellParser<String> toName, CellParser<Date> toDate) {
        if (sheet.getRowCount() < 2 || sheet.getColumnCount() < 2) {
            return SpreadSheetCollection.AlignType.UNKNOWN;
        }
        if (toName.tryParse(sheet, 0, 1).isPresent() && toDate.tryParse(sheet, 1, 0).isPresent()) {
            return SpreadSheetCollection.AlignType.VERTICAL;
        }
        if (toDate.tryParse(sheet, 0, 1).isPresent() && toName.tryParse(sheet, 1, 0).isPresent()) {
            return SpreadSheetCollection.AlignType.HORIZONTAL;
        }
        return SpreadSheetCollection.AlignType.UNKNOWN;
    }

    private static List<Date> getVerticalDates(Sheet sheet, CellParser<Date> toDate) {
        Date date;
        ArrayList<Date> result = new ArrayList<Date>();
        for (int rowIdx = 1; rowIdx < sheet.getRowCount() && (date = toDate.parse(sheet, rowIdx, 0)) != null; ++rowIdx) {
            result.add(date);
        }
        return result;
    }

    private static List<String> getHorizontalNames(Sheet sheet, CellParser<String> toName) {
        String name;
        ArrayList<String> result = new ArrayList<String>();
        for (int columnIdx = 1; columnIdx < sheet.getColumnCount() && (name = toName.parse(sheet, 0, columnIdx)) != null; ++columnIdx) {
            result.add(name);
        }
        return result;
    }

    private static SpreadSheetCollection loadVertically(SpreadSheetCollection.AlignType alignType, int ordering, Sheet sheet, CellParser<String> toName, CellParser<Date> toDate, CellParser<Number> toNumber, TsFrequency frequency, TsAggregationType aggregationType, boolean clean) {
        List<Date> dates = Engine.getVerticalDates(sheet, toDate);
        List<String> names = Engine.getHorizontalNames(sheet, toName);
        ImmutableList.Builder list = ImmutableList.builder();
        ObsGathering gathering = clean ? ObsGathering.excludingMissingValues((TsFrequency)frequency, (TsAggregationType)aggregationType) : ObsGathering.includingMissingValues((TsFrequency)frequency, (TsAggregationType)aggregationType);
        OptionalTsData.Builder2 data = OptionalTsData.builderByDate((Calendar)new GregorianCalendar(), (ObsGathering)gathering, (ObsCharacteristics[])new ObsCharacteristics[0]);
        for (int columnIdx = 0; columnIdx < names.size(); ++columnIdx) {
            for (int rowIdx = 0; rowIdx < dates.size(); ++rowIdx) {
                Number value = toNumber.parse(sheet, rowIdx + 1, columnIdx + 1);
                data.add((Object)dates.get(rowIdx), value);
            }
            list.add((Object)new SpreadSheetSeries(names.get(columnIdx), columnIdx, alignType, data.build()));
            data.clear();
        }
        return new SpreadSheetCollection(sheet.getName(), ordering, alignType, (ImmutableList<SpreadSheetSeries>)list.build());
    }
}

