/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.spreadsheet.engine;

import com.google.common.collect.ImmutableList;
import ec.tss.tsproviders.spreadsheet.engine.CellParser;
import ec.tss.tsproviders.spreadsheet.engine.Engine;
import ec.tss.tsproviders.spreadsheet.engine.SpreadSheetSeries;
import ec.tss.tsproviders.spreadsheet.facade.Sheet;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class SpreadSheetCollection
implements Comparable<SpreadSheetCollection> {
    public final String sheetName;
    public final int ordering;
    public final AlignType alignType;
    public final ImmutableList<SpreadSheetSeries> series;
    private final Map<String, Integer> map;

    @Deprecated
    public static SpreadSheetCollection load(Sheet sheet, int ordering, CellParser<String> toName, CellParser<Date> toDate, CellParser<Number> toNumber, TsFrequency frequency, TsAggregationType aggregationType, boolean clean) {
        return Engine.parseCollection(sheet, ordering, toName, toDate, toNumber, frequency, aggregationType, clean);
    }

    public SpreadSheetCollection(@NonNull String sheetName, int ordering, @NonNull AlignType alignType, @NonNull ImmutableList<SpreadSheetSeries> series) {
        this(sheetName, ordering, alignType, series, new HashMap<String, Integer>());
    }

    private SpreadSheetCollection(String sheetName, int ordering, AlignType alignType, ImmutableList<SpreadSheetSeries> series, Map<String, Integer> map) {
        this.sheetName = sheetName;
        this.ordering = ordering;
        this.alignType = alignType;
        this.series = series;
        this.map = map;
    }

    @Override
    public int compareTo(SpreadSheetCollection o) {
        int result = Integer.compare(this.ordering, o.ordering);
        if (result != 0) {
            return result;
        }
        return this.sheetName.compareTo(o.sheetName);
    }

    public int hashCode() {
        return Objects.hash(this.ordering, this.sheetName);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SpreadSheetCollection && this.equals((SpreadSheetCollection)obj);
    }

    private boolean equals(SpreadSheetCollection that) {
        return this.ordering == that.ordering && this.sheetName.equals(that.sheetName);
    }

    @Deprecated
    public SpreadSheetSeries searchOldName(String name) {
        int pos = 0;
        for (SpreadSheetSeries item : this.series) {
            String iname = item.seriesName;
            if ((iname = iname.replace('.', '#')).length() > 64) {
                iname = iname.substring(0, 64);
            }
            int c = 1;
            while (this.map.containsKey(iname)) {
                String nid = Integer.toString(c++);
                iname = iname.substring(0, iname.length() - nid.length());
                iname = iname + nid;
            }
            this.map.put(iname, pos++);
        }
        Integer ipos = this.map.get(name);
        if (ipos == null) {
            return null;
        }
        return (SpreadSheetSeries)this.series.get(ipos.intValue());
    }

    @Deprecated
    public static AlignType getAlignType(Sheet sheet, CellParser<String> toName, CellParser<Date> toDate) {
        return Engine.parseAlignType(sheet, toName, toDate);
    }

    public static enum AlignType {
        VERTICAL,
        HORIZONTAL,
        UNKNOWN;

    }
}

