/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.spreadsheet.engine;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import ec.tss.TsCollectionInformation;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.tsproviders.spreadsheet.engine.SpreadSheetCollection;
import ec.tss.tsproviders.spreadsheet.engine.SpreadSheetSeries;
import ec.tss.tsproviders.spreadsheet.engine.SpreadSheetSource;
import ec.tss.tsproviders.spreadsheet.engine.TsExportOptions;
import ec.tss.tsproviders.spreadsheet.engine.TsImportOptions;
import ec.tss.tsproviders.utils.IParser;
import ec.tss.tsproviders.utils.ObsCharacteristics;
import ec.tss.tsproviders.utils.ObsGathering;
import ec.tss.tsproviders.utils.OptionalTsData;
import ec.tstoolkit.data.Table;
import ec.tstoolkit.design.VisibleForTesting;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.timeseries.simplets.TsDataTable;
import ec.tstoolkit.timeseries.simplets.TsDataTableInfo;
import ec.util.spreadsheet.Book;
import ec.util.spreadsheet.Cell;
import ec.util.spreadsheet.Sheet;
import ec.util.spreadsheet.helpers.ArraySheet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SpreadSheetFactory {
    public abstract @NonNull SpreadSheetSource toSource(@NonNull Book var1, @NonNull TsImportOptions var2) throws IOException;

    public abstract @NonNull TsCollectionInformation toTsCollectionInfo(@NonNull Sheet var1, @NonNull TsImportOptions var2);

    public abstract @NonNull Table<?> toTable(@NonNull Sheet var1);

    public abstract @NonNull ArraySheet fromTsCollectionInfo(@NonNull TsCollectionInformation var1, @NonNull TsExportOptions var2);

    public abstract @NonNull ArraySheet fromMatrix(@NonNull Matrix var1);

    public abstract @NonNull ArraySheet fromTable(@NonNull Table<?> var1);

    public static @NonNull SpreadSheetFactory getDefault() {
        return DefaultImpl.INSTANCE;
    }

    private static ArraySheet newArraySheet(String name, Matrix matrix) {
        ArraySheet.Builder result = ArraySheet.builder((int)matrix.getRowsCount(), (int)matrix.getColumnsCount()).name(name);
        for (int i = 0; i < matrix.getRowsCount(); ++i) {
            for (int j = 0; j < matrix.getColumnsCount(); ++j) {
                result.value(i, j, (Object)matrix.get(i, j));
            }
        }
        return result.build();
    }

    private static ArraySheet newArraySheet(String name, Table<?> table) {
        ArraySheet.Builder result = ArraySheet.builder((int)table.getRowsCount(), (int)table.getColumnsCount()).name(name);
        for (int i = 0; i < table.getRowsCount(); ++i) {
            for (int j = 0; j < table.getColumnsCount(); ++j) {
                result.value(i, j, table.get(i, j));
            }
        }
        return result.build();
    }

    @VisibleForTesting
    static final class DefaultImpl
    extends SpreadSheetFactory {
        private static final DefaultImpl INSTANCE = new DefaultImpl();
        private static final int FIRST_DATA_COL_IDX = 1;
        private static final Joiner NAME_JOINER = Joiner.on((String)"\n").skipNulls();

        DefaultImpl() {
        }

        @Override
        public SpreadSheetSource toSource(Book book, TsImportOptions options) throws IOException {
            return DefaultImpl.parseSource(book, options);
        }

        @Override
        public ArraySheet fromTsCollectionInfo(TsCollectionInformation col, TsExportOptions options) {
            TsDataTable table = new TsDataTable();
            for (TsInformation o2 : col.items) {
                table.insert(-1, o2.data);
            }
            if (table.getDomain() != null) {
                ArraySheet.Builder builder = ArraySheet.builder().name("dnd");
                if (options.isShowTitle()) {
                    builder.row(0, options.isShowDates() ? 1 : 0, col.items.stream().map(o -> o.name).iterator());
                }
                if (options.isShowDates()) {
                    builder.column(options.isShowTitle() ? 1 : 0, 0, Streams.stream((Iterable)table.getDomain()).map(options.isBeginPeriod() ? o -> o.firstday().getTime() : o -> o.lastday().getTime()).iterator());
                }
                int firstRow = options.isShowTitle() ? 1 : 0;
                int firstColumn = options.isShowDates() ? 1 : 0;
                int rowCount = table.getDomain().getLength();
                int columnCount = col.items.size();
                for (int i = 0; i < rowCount; ++i) {
                    for (int j = 0; j < columnCount; ++j) {
                        if (table.getDataInfo(i, j) != TsDataTableInfo.Valid) continue;
                        builder.value(firstRow + i, firstColumn + j, (Object)table.getData(i, j));
                    }
                }
                ArraySheet sheet = builder.build();
                if (!options.isVertical()) {
                    sheet = sheet.inv();
                }
                return sheet;
            }
            return ArraySheet.builder().name("dnd").build();
        }

        @Override
        public TsCollectionInformation toTsCollectionInfo(Sheet sheet, TsImportOptions options) {
            TsCollectionInformation result = new TsCollectionInformation();
            result.name = sheet.getName();
            result.type = TsInformationType.All;
            for (SpreadSheetSeries s : DefaultImpl.parseCollection((Sheet)sheet, (int)0, (Context)Context.create((TsImportOptions)options)).series) {
                TsInformation tsInfo = new TsInformation();
                tsInfo.name = s.seriesName;
                tsInfo.type = TsInformationType.All;
                if (s.data.isPresent()) {
                    tsInfo.data = s.data.get();
                    tsInfo.invalidDataCause = null;
                } else {
                    tsInfo.data = null;
                    tsInfo.invalidDataCause = s.data.getCause();
                }
                result.items.add(tsInfo);
            }
            return result;
        }

        @Override
        public ArraySheet fromMatrix(Matrix matrix) {
            return SpreadSheetFactory.newArraySheet("dnd", matrix);
        }

        @Override
        public Table<?> toTable(Sheet sheet) {
            Table result = new Table(sheet.getRowCount(), sheet.getColumnCount());
            sheet.forEachValue((arg_0, arg_1, arg_2) -> ((Table)result).set(arg_0, arg_1, arg_2));
            return result;
        }

        @Override
        public ArraySheet fromTable(Table<?> table) {
            return SpreadSheetFactory.newArraySheet("dnd", table);
        }

        @VisibleForTesting
        static SpreadSheetSource parseSource(Book book, TsImportOptions options) throws IOException {
            int sheetCount = book.getSheetCount();
            SpreadSheetCollection[] result = new SpreadSheetCollection[sheetCount];
            book.parallelForEach((sheet, i) -> {
                result[i] = DefaultImpl.parseCollection(sheet, i, Context.create(options));
            });
            return new SpreadSheetSource(Arrays.asList(result), "?");
        }

        @VisibleForTesting
        static SpreadSheetCollection parseCollection(Sheet sheet, int ordering, Context context) {
            DateHeader rowDates = new DateHeader(sheet.getRowCount());
            for (int i = 0; i < sheet.getRowCount(); ++i) {
                rowDates.set(i, context.toDate.parse(sheet, i, 0));
            }
            DateHeader colDates = new DateHeader(sheet.getColumnCount());
            for (int j = 0; j < sheet.getColumnCount(); ++j) {
                colDates.set(j, context.toDate.parse(sheet, 0, j));
            }
            if (rowDates.isBetter(colDates)) {
                return DefaultImpl.loadVertically(SpreadSheetCollection.AlignType.VERTICAL, ordering, sheet, context, rowDates);
            }
            if (colDates.isBetter(rowDates)) {
                return DefaultImpl.loadVertically(SpreadSheetCollection.AlignType.HORIZONTAL, ordering, sheet.inv(), context, colDates);
            }
            return new SpreadSheetCollection(sheet.getName(), ordering, SpreadSheetCollection.AlignType.UNKNOWN, (ImmutableList<SpreadSheetSeries>)ImmutableList.of());
        }

        private static List<String> getHorizontalNames(Sheet sheet, Context context, int level) {
            ArrayList<String> result = new ArrayList<String>();
            block0 : switch (level) {
                case 0: {
                    for (int columnIdx = 1; columnIdx < sheet.getColumnCount() && context.toNumber.parse(sheet, 0, columnIdx) != null; ++columnIdx) {
                        result.add("S" + columnIdx);
                    }
                    break;
                }
                case 1: {
                    String name;
                    for (int columnIdx = 1; columnIdx < sheet.getColumnCount() && (name = context.toName.parse(sheet, 0, columnIdx)) != null; ++columnIdx) {
                        result.add(name);
                    }
                    break;
                }
                default: {
                    Object[] path = new String[level];
                    for (int columnIdx = 1; columnIdx < sheet.getColumnCount(); ++columnIdx) {
                        boolean hasHeader = false;
                        for (int rowIdx = 0; rowIdx < path.length; ++rowIdx) {
                            String name = context.toName.parse(sheet, rowIdx, columnIdx);
                            if (name != null) {
                                hasHeader = true;
                                path[rowIdx] = name;
                                continue;
                            }
                            if (!hasHeader) continue;
                            path[rowIdx] = null;
                        }
                        if (!hasHeader) break block0;
                        result.add(NAME_JOINER.join(path));
                    }
                }
            }
            return result;
        }

        private static SpreadSheetCollection loadVertically(SpreadSheetCollection.AlignType alignType, int ordering, Sheet sheet, Context context, DateHeader dates) {
            List<String> names = DefaultImpl.getHorizontalNames(sheet, context, dates.minIndex);
            ImmutableList.Builder list = ImmutableList.builder();
            OptionalTsData.Builder2 data = OptionalTsData.builderByDate((Calendar)context.cal, (ObsGathering)context.gathering, (ObsCharacteristics[])new ObsCharacteristics[0]);
            for (int columnIdx = 0; columnIdx < names.size(); ++columnIdx) {
                for (int rowIdx = dates.getMinIndex(); rowIdx <= dates.getMaxIndex(); ++rowIdx) {
                    Number value = context.toNumber.parse(sheet, rowIdx, columnIdx + 1);
                    data.add((Object)dates.get(rowIdx), value);
                }
                list.add((Object)new SpreadSheetSeries(names.get(columnIdx), columnIdx, alignType, data.build()));
                data.clear();
            }
            return new SpreadSheetCollection(sheet.getName(), ordering, alignType, (ImmutableList<SpreadSheetSeries>)list.build());
        }
    }

    private static final class DateHeader {
        private final Date[] dates;
        private int minIndex;
        private int maxIndex;

        public DateHeader(int maxSize) {
            this.dates = new Date[maxSize];
            this.minIndex = maxSize - 1;
            this.maxIndex = 0;
        }

        public void set(int i, Date value) {
            this.dates[i] = value;
            if (value != null) {
                if (i < this.minIndex) {
                    this.minIndex = i;
                }
                if (i > this.maxIndex) {
                    this.maxIndex = i;
                }
            }
        }

        public Date get(int i) {
            return this.dates[i];
        }

        public int getMinIndex() {
            return this.minIndex;
        }

        public int getMaxIndex() {
            return this.maxIndex;
        }

        public boolean isBetter(DateHeader other) {
            int count = this.maxIndex - this.minIndex + 1;
            return count > 0 && count > other.maxIndex - other.minIndex + 1;
        }
    }

    @VisibleForTesting
    static abstract class CellParser<T> {
        CellParser() {
        }

        public abstract @Nullable T parse(@NonNull Sheet var1, int var2, int var3);

        public @NonNull Optional<T> tryParse(@NonNull Sheet sheet, int rowIndex, int columnIndex) {
            return Optional.fromNullable(this.parse(sheet, rowIndex, columnIndex));
        }

        public @NonNull CellParser<T> or(CellParser<T> ... cellParser) {
            switch (cellParser.length) {
                case 0: {
                    return this;
                }
                case 1: {
                    return CellParser.firstNotNull(ImmutableList.of((Object)this, cellParser[0]));
                }
            }
            return CellParser.firstNotNull(ImmutableList.builder().add((Object)this).add((Object[])cellParser).build());
        }

        public static <X> @NonNull CellParser<X> firstNotNull(@NonNull ImmutableList<? extends CellParser<X>> list) {
            return new FirstNotNull(list);
        }

        public static <X> @NonNull CellParser<X> fromParser(@NonNull IParser<X> parser) {
            return new Adapter<X>(parser);
        }

        public static @NonNull CellParser<Date> onDateType() {
            return DateCellFunc.INSTANCE;
        }

        public static @NonNull CellParser<Number> onNumberType() {
            return NumberCellFunc.INSTANCE;
        }

        public static @NonNull CellParser<String> onStringType() {
            return StringCellFunc.INSTANCE;
        }

        private static final class FirstNotNull<X>
        extends CellParser<X> {
            private final ImmutableList<? extends CellParser<X>> list;

            FirstNotNull(ImmutableList<? extends CellParser<X>> list) {
                this.list = list;
            }

            @Override
            public X parse(Sheet sheet, int rowIndex, int columnIndex) {
                for (CellParser o : this.list) {
                    Object result = o.parse(sheet, rowIndex, columnIndex);
                    if (result == null) continue;
                    return (X)result;
                }
                return null;
            }
        }

        private static final class Adapter<X>
        extends CellParser<X> {
            private final IParser<X> adaptee;

            Adapter(IParser<X> parser) {
                this.adaptee = parser;
            }

            @Override
            public X parse(Sheet sheet, int rowIndex, int columnIndex) {
                String input = StringCellFunc.INSTANCE.parse(sheet, rowIndex, columnIndex);
                return (X)(input != null ? this.adaptee.parse((CharSequence)input) : null);
            }
        }

        private static final class DateCellFunc
        extends CellParser<Date> {
            static final DateCellFunc INSTANCE = new DateCellFunc();

            private DateCellFunc() {
            }

            @Override
            public Date parse(Sheet sheet, int rowIndex, int columnIndex) {
                Cell cell = sheet.getCell(rowIndex, columnIndex);
                return cell != null && cell.isDate() ? cell.getDate() : null;
            }
        }

        private static final class NumberCellFunc
        extends CellParser<Number> {
            static final NumberCellFunc INSTANCE = new NumberCellFunc();

            private NumberCellFunc() {
            }

            @Override
            public Number parse(Sheet sheet, int rowIndex, int columnIndex) {
                Cell cell = sheet.getCell(rowIndex, columnIndex);
                return cell != null && cell.isNumber() ? (Number)cell.getNumber() : (Number)null;
            }
        }

        private static final class StringCellFunc
        extends CellParser<String> {
            static final StringCellFunc INSTANCE = new StringCellFunc();

            private StringCellFunc() {
            }

            @Override
            public String parse(Sheet sheet, int rowIndex, int columnIndex) {
                Cell cell = sheet.getCell(rowIndex, columnIndex);
                return cell != null && cell.isString() ? cell.getString() : null;
            }
        }
    }

    @VisibleForTesting
    static final class Context {
        public final CellParser<String> toName;
        public final CellParser<Date> toDate;
        public final CellParser<Number> toNumber;
        public final ObsGathering gathering;
        public final Calendar cal;

        public Context(CellParser<String> toName, CellParser<Date> toDate, CellParser<Number> toNumber, ObsGathering gathering) {
            this.toName = toName;
            this.toDate = toDate;
            this.toNumber = toNumber;
            this.gathering = gathering;
            this.cal = new GregorianCalendar();
        }

        private static Context create(TsImportOptions options) {
            return new Context(CellParser.onStringType(), CellParser.onDateType().or(CellParser.fromParser(options.getDataFormat().dateParser())), CellParser.onNumberType().or(CellParser.fromParser(options.getDataFormat().numberParser())), options.getObsGathering());
        }
    }
}

