/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.spreadsheet.engine;

import ec.tss.tsproviders.spreadsheet.engine.SpreadSheetCollection;
import ec.tss.tsproviders.utils.OptionalTsData;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class SpreadSheetSeries
implements Comparable<SpreadSheetSeries> {
    public final String seriesName;
    public final int ordering;
    public final SpreadSheetCollection.AlignType alignType;
    public final OptionalTsData data;

    public SpreadSheetSeries(@NonNull String seriesName, int ordering, @NonNull SpreadSheetCollection.AlignType alignType, @NonNull OptionalTsData data) {
        this.seriesName = seriesName;
        this.ordering = ordering;
        this.alignType = alignType;
        this.data = data;
    }

    @Override
    public int compareTo(SpreadSheetSeries o) {
        int result = Integer.compare(this.ordering, o.ordering);
        if (result != 0) {
            return result;
        }
        return this.seriesName.compareTo(o.seriesName);
    }

    public int hashCode() {
        return Objects.hash(this.ordering, this.seriesName);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SpreadSheetSeries && this.equals((SpreadSheetSeries)obj);
    }

    private boolean equals(SpreadSheetSeries that) {
        return this.ordering == that.ordering && this.seriesName.equals(that.seriesName);
    }
}

