/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.spreadsheet.engine;

import com.google.common.base.MoreObjects;
import ec.tss.tsproviders.utils.DataFormat;
import ec.tss.tsproviders.utils.ObsGathering;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TsImportOptions {
    private static final TsImportOptions DEFAULT = TsImportOptions.create(DataFormat.DEFAULT, ObsGathering.excludingMissingValues((TsFrequency)TsFrequency.Undefined, (TsAggregationType)TsAggregationType.None));
    private final DataFormat dataFormat;
    private final ObsGathering gathering;

    @Deprecated
    public static @NonNull TsImportOptions create(DataFormat dataFormat, TsFrequency frequency, TsAggregationType aggregationType, boolean cleanMissing) {
        ObsGathering gathering = cleanMissing ? ObsGathering.excludingMissingValues((TsFrequency)frequency, (TsAggregationType)aggregationType) : ObsGathering.includingMissingValues((TsFrequency)frequency, (TsAggregationType)aggregationType);
        return new TsImportOptions(dataFormat, gathering);
    }

    public static @NonNull TsImportOptions create(DataFormat dataFormat, ObsGathering gathering) {
        return new TsImportOptions(dataFormat, gathering);
    }

    public static @NonNull TsImportOptions getDefault() {
        return DEFAULT;
    }

    private TsImportOptions(DataFormat dataFormat, ObsGathering gathering) {
        this.dataFormat = dataFormat;
        this.gathering = gathering;
    }

    public @NonNull DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public @NonNull ObsGathering getObsGathering() {
        return this.gathering;
    }

    @Deprecated
    public @NonNull TsFrequency getFrequency() {
        return this.gathering.getFrequency();
    }

    @Deprecated
    public @NonNull TsAggregationType getAggregationType() {
        return this.gathering.getAggregationType();
    }

    @Deprecated
    public boolean isCleanMissing() {
        return this.gathering.isSkipMissingValues();
    }

    public int hashCode() {
        return Objects.hash(this.dataFormat, this.gathering);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TsImportOptions && this.equals((TsImportOptions)obj);
    }

    private boolean equals(TsImportOptions that) {
        return Objects.equals(this.dataFormat, that.dataFormat) && Objects.equals(this.gathering, that.gathering);
    }

    public String toString() {
        return MoreObjects.toStringHelper(TsImportOptions.class).add("dataFormat", (Object)this.dataFormat).add("collectionParams", (Object)this.gathering).toString();
    }
}

