/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.spreadsheet.facade;

import ec.tss.tsproviders.spreadsheet.facade.Cell;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Deprecated
public abstract class Sheet {
    public abstract int getRowCount();

    public abstract int getColumnCount();

    public abstract @Nullable Cell getCell(int var1, int var2) throws IndexOutOfBoundsException;

    public abstract @NonNull String getName();

    public @NonNull Sheet inv() {
        return this instanceof InvSheet ? ((InvSheet)this).sheet : new InvSheet(this);
    }

    @Deprecated
    public @NonNull Sheet memoize() {
        return this instanceof MemoizedSheet ? this : new MemoizedSheet(this);
    }

    private static class InvSheet
    extends Sheet {
        final Sheet sheet;

        InvSheet(Sheet sheet) {
            this.sheet = sheet;
        }

        @Override
        public int getRowCount() {
            return this.sheet.getColumnCount();
        }

        @Override
        public int getColumnCount() {
            return this.sheet.getRowCount();
        }

        @Override
        public Cell getCell(int rowIdx, int columnIdx) {
            return this.sheet.getCell(columnIdx, rowIdx);
        }

        @Override
        public String getName() {
            return this.sheet.getName();
        }
    }

    private static class MemoizedSheet
    extends Sheet {
        final Sheet sheet;
        final int rowCount;
        final int columnCount;
        final String name;
        final Cell[][] data;

        MemoizedSheet(Sheet sheet) {
            this.sheet = sheet;
            this.rowCount = sheet.getRowCount();
            this.columnCount = sheet.getColumnCount();
            this.name = sheet.getName();
            this.data = new Cell[this.rowCount][this.columnCount];
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        @Override
        public int getColumnCount() {
            return this.columnCount;
        }

        @Override
        public Cell getCell(int rowIdx, int columnIdx) {
            Cell result = this.data[rowIdx][columnIdx];
            if (result == null) {
                result = this.sheet.getCell(rowIdx, columnIdx);
                this.data[rowIdx][columnIdx] = result == null ? NullCell.INSTANCE : result;
            }
            return NullCell.INSTANCE.equals(result) ? null : result;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static class NullCell
    extends Cell {
        static final NullCell INSTANCE = new NullCell();

        private NullCell() {
        }
    }
}

