/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.spreadsheet.facade.utils;

import com.google.common.io.InputSupplier;
import ec.tss.tsproviders.spreadsheet.facade.Book;
import ec.tss.tsproviders.spreadsheet.facade.Cell;
import ec.tss.tsproviders.spreadsheet.facade.Sheet;
import ec.tss.tsproviders.spreadsheet.facade.utils.BookFactoryAdapter;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.util.spreadsheet.helpers.ArraySheet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Deprecated
public class MemBook
extends Book {
    private final List<ec.util.spreadsheet.Sheet> sheets;

    private MemBook(List<ec.util.spreadsheet.Sheet> sheets) {
        this.sheets = sheets;
    }

    @Override
    public int getSheetCount() {
        return this.sheets.size();
    }

    @Override
    public Sheet getSheet(int index) {
        return new BookFactoryAdapter.ToSheetAdapter(this.sheets.get(index));
    }

    @Override
    public String getFactoryName() {
        return "BookBuilder";
    }

    public static class Builder {
        private final SheetStep sheetBuilder = new SheetStep();
        private final List<ec.util.spreadsheet.Sheet> sheets = new ArrayList<ec.util.spreadsheet.Sheet>();

        public MemBook build() {
            return new MemBook(new ArrayList<ec.util.spreadsheet.Sheet>(this.sheets));
        }

        public Builder clear() {
            this.sheets.clear();
            return this;
        }

        @Deprecated
        public Builder copy(InputSupplier<Book> bookSupplier) throws IOException {
            try (Book book = (Book)bookSupplier.getInput();){
                Builder builder = this.copy(book);
                return builder;
            }
        }

        public Builder copy(Book book) throws IOException {
            for (int s = 0; s < book.getSheetCount(); ++s) {
                Sheet sheet = book.getSheet(s);
                this.sheet(sheet.getName()).copy(0, 0, sheet).add();
            }
            return this;
        }

        public SheetStep sheet(String name) {
            return this.sheetBuilder.clear().name(name);
        }

        public class SheetStep {
            private final ArraySheet.Builder data = ArraySheet.builder();
            private boolean inv = false;

            private SheetStep() {
            }

            public SheetStep clear() {
                this.data.clear();
                return this;
            }

            public SheetStep name(String name) {
                this.data.name(name);
                return this;
            }

            public SheetStep copy(int row, int col, Sheet sheet) {
                for (int i = 0; i < sheet.getRowCount(); ++i) {
                    for (int j = 0; j < sheet.getColumnCount(); ++j) {
                        this.copy(row + i, col + j, sheet.getCell(i, j));
                    }
                }
                return this;
            }

            public SheetStep copy(int row, int col, Cell cell) {
                this.cell(row, col, cell == null ? null : (cell.isDate() ? cell.getDate() : (cell.isNumber() ? cell.getNumber() : (cell.isString() ? cell.getString() : null))));
                return this;
            }

            public SheetStep row(int row, int col, Object[] values) {
                for (int j = 0; j < values.length; ++j) {
                    this.cell(row, col + j, values[j]);
                }
                return this;
            }

            public SheetStep column(int row, int col, Object[] values) {
                for (int i = 0; i < values.length; ++i) {
                    this.cell(row + i, col, values[i]);
                }
                return this;
            }

            public SheetStep matrix(int row, int col, Matrix matrix) {
                for (int i = 0; i < matrix.getRowsCount(); ++i) {
                    for (int j = 0; j < matrix.getColumnsCount(); ++j) {
                        this.cell(row + i, col + j, matrix.get(i, j));
                    }
                }
                return this;
            }

            public SheetStep cell(int row, int col, Object value) {
                return !this.inv ? this.putCellValue(row, col, value) : this.putCellValue(col, row, value);
            }

            private SheetStep putCellValue(int row, int col, Object value) {
                if (row < 0 || col < 0) {
                    return this;
                }
                Object cellValue = this.getCellValue(value);
                if (cellValue == null) {
                    return this;
                }
                this.data.value(row, col, cellValue);
                return this;
            }

            private Object getCellValue(Object value) {
                if (value instanceof Date) {
                    return value;
                }
                if (value instanceof Number) {
                    return value;
                }
                if (value instanceof String) {
                    return value;
                }
                if (value != null) {
                    return value.toString();
                }
                return null;
            }

            public SheetStep inv() {
                this.inv = !this.inv;
                return this;
            }

            public Builder add() {
                ArraySheet sheet = this.data.build();
                Builder.this.sheets.add(this.inv ? sheet.inv() : sheet);
                return Builder.this;
            }
        }
    }
}

