/*
 * Decompiled with CFR 0.152.
 */
package ec.demetra.xml.calendars;

import ec.demetra.xml.calendars.CalendarAdapter;
import ec.demetra.xml.calendars.XmlCalendar;
import ec.tstoolkit.timeseries.calendars.GregorianCalendarManager;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import internal.xml.calendars.CalendarAdapterLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class CalendarAdapters {
    private static final AtomicReference<CalendarAdapters> defadapters = new AtomicReference();
    private final List<CalendarAdapter> adapters = new ArrayList<CalendarAdapter>();

    public static final CalendarAdapters getDefault() {
        defadapters.compareAndSet(null, CalendarAdapters.make());
        return defadapters.get();
    }

    public CalendarAdapters() {
        this.load();
    }

    public static final void setDefault(CalendarAdapters adapters) {
        defadapters.set(adapters);
    }

    private static CalendarAdapters make() {
        CalendarAdapters adapters = new CalendarAdapters();
        return adapters;
    }

    private void load() {
        this.adapters.addAll(new CalendarAdapterLoader().get());
    }

    public List<Class> getXmlClasses() {
        return this.adapters.stream().map(adapter -> adapter.getXmlType()).collect(Collectors.toList());
    }

    public IGregorianCalendarProvider unmarshal(XmlCalendar xvar) {
        for (CalendarAdapter adapter : this.adapters) {
            if (!adapter.getXmlType().isInstance(xvar)) continue;
            try {
                return (IGregorianCalendarProvider)adapter.unmarshal(xvar);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public IGregorianCalendarProvider unmarshal(XmlCalendar xvar, GregorianCalendarManager mgr) {
        for (CalendarAdapter adapter : this.adapters) {
            if (!adapter.getXmlType().isInstance(xvar)) continue;
            try {
                return adapter.unmarshal(xvar, mgr);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public XmlCalendar marshal(IGregorianCalendarProvider ivar) {
        for (CalendarAdapter adapter : this.adapters) {
            if (!adapter.getValueType().isInstance(ivar)) continue;
            try {
                return (XmlCalendar)adapter.marshal(ivar);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }
}

