/*
 * Decompiled with CFR 0.152.
 */
package ec.demetra.xml.calendars;

import ec.demetra.xml.calendars.DayAdapter;
import ec.demetra.xml.calendars.XmlDay;
import ec.tstoolkit.timeseries.calendars.ISpecialDay;
import internal.xml.calendars.DayAdapterLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class DayAdapters {
    private static final AtomicReference<DayAdapters> defadapters = new AtomicReference();
    private final List<DayAdapter> adapters = new ArrayList<DayAdapter>();

    public static final DayAdapters getDefault() {
        defadapters.compareAndSet(null, DayAdapters.make());
        return defadapters.get();
    }

    public static final void setDefault(DayAdapters adapters) {
        defadapters.set(adapters);
    }

    private static DayAdapters make() {
        DayAdapters adapters = new DayAdapters();
        adapters.load();
        return adapters;
    }

    public void load() {
        this.adapters.addAll(new DayAdapterLoader().get());
    }

    public List<Class> getXmlClasses() {
        return this.adapters.stream().map(adapter -> adapter.getXmlType()).collect(Collectors.toList());
    }

    public ISpecialDay unmarshal(XmlDay xvar) {
        for (DayAdapter adapter : this.adapters) {
            if (!adapter.getXmlType().isInstance(xvar)) continue;
            try {
                return (ISpecialDay)adapter.unmarshal(xvar);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public XmlDay marshal(ISpecialDay ivar) {
        for (DayAdapter adapter : this.adapters) {
            if (!adapter.getValueType().isInstance(ivar)) continue;
            try {
                return (XmlDay)adapter.marshal(ivar);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }
}

