/*
 * Decompiled with CFR 0.152.
 */
package ec.demetra.xml.core;

import ec.demetra.xml.core.XmlMetaData;
import ec.demetra.xml.core.XmlTs;
import ec.tss.Ts;
import ec.tss.TsCollection;
import ec.tss.TsCollectionInformation;
import ec.tss.TsFactory;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tss.xml.IXmlUnmarshaller;
import ec.tss.xml.InPlaceXmlMarshaller;
import ec.tstoolkit.MetaData;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="TsCollection")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TsCollectionType", propOrder={"metaData", "data"})
public class XmlTsCollection {
    @XmlElement(name="MetaData")
    @XmlJavaTypeAdapter(value=XmlMetaData.Adapter.class)
    protected MetaData metaData;
    @XmlElement(name="Data", required=true)
    protected Data data;
    @XmlAttribute(name="name")
    protected String name;
    @XmlAttribute(name="source")
    protected String source;
    @XmlAttribute(name="identifier")
    protected String identifier;
    public static final IXmlUnmarshaller<XmlTsCollection, TsCollectionInformation> INFO_UNMARSHALLER = xml -> {
        TsMoniker moniker = TsMoniker.create(xml.source, xml.identifier);
        TsCollectionInformation cinfo = new TsCollectionInformation(moniker, TsInformationType.UserDefined);
        cinfo.name = xml.name;
        if (xml.metaData != null) {
            cinfo.metaData = xml.metaData;
        }
        if (xml.data != null) {
            for (XmlTs xs : xml.data.getTs()) {
                cinfo.items.add(XmlTs.INFO_UNMARSHALLER.unmarshal(xs));
            }
        }
        return cinfo;
    };
    public static final IXmlUnmarshaller<XmlTsCollection, TsCollection> UNMARSHALLER = xml -> {
        TsCollectionInformation info = INFO_UNMARSHALLER.unmarshal((XmlTsCollection)xml);
        if (info == null) {
            return null;
        }
        ArrayList<Ts> ts = new ArrayList<Ts>();
        if (info.items != null) {
            for (TsInformation tsinfo : info.items) {
                ts.add(TsFactory.instance.createTs(tsinfo.name, tsinfo.moniker, tsinfo.metaData, tsinfo.data));
            }
        }
        return TsFactory.instance.createTsCollection(info.name, info.moniker, info.metaData, ts);
    };
    public static final InPlaceXmlMarshaller<XmlTsCollection, TsCollectionInformation> INFO_MARSHALLER = (v, xml) -> {
        xml.source = v.moniker.getSource();
        xml.identifier = v.moniker.getId();
        xml.name = v.name;
        if (v.metaData != null && !v.metaData.isEmpty()) {
            xml.metaData = v.metaData;
        }
        if (!v.items.isEmpty()) {
            xml.data = new Data();
            for (TsInformation info : v.items) {
                XmlTs xs = new XmlTs();
                XmlTs.INFO_MARSHALLER.marshal(info, xs);
                xml.data.getTs().add(xs);
            }
        }
        return true;
    };
    public static final InPlaceXmlMarshaller<XmlTsCollection, TsCollection> MARSHALLER = (v, xml) -> {
        xml.source = v.getMoniker().getSource();
        xml.identifier = v.getMoniker().getId();
        xml.name = v.getName();
        xml.metaData = v.getMetaData();
        int n = v.getCount();
        if (n > 0) {
            xml.data = new Data();
            for (Ts s : v) {
                XmlTs xs = new XmlTs();
                XmlTs.MARSHALLER.marshal(s, xs);
                xml.data.getTs().add(xs);
            }
        }
        return true;
    };
    private static final Adapter ADAPTER = new Adapter();

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData value) {
        this.metaData = value;
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data value) {
        this.data = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String value) {
        this.source = value;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String value) {
        this.identifier = value;
    }

    public static XmlAdapter<XmlTsCollection, TsCollectionInformation> getTsAdapter() {
        return ADAPTER;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"ts"})
    public static class Data {
        @XmlElement(name="Ts")
        protected List<XmlTs> ts;

        public List<XmlTs> getTs() {
            if (this.ts == null) {
                this.ts = new ArrayList<XmlTs>();
            }
            return this.ts;
        }
    }

    public static class Adapter
    extends XmlAdapter<XmlTsCollection, TsCollectionInformation> {
        public TsCollectionInformation unmarshal(XmlTsCollection v) throws Exception {
            return INFO_UNMARSHALLER.unmarshal(v);
        }

        public XmlTsCollection marshal(TsCollectionInformation v) throws Exception {
            XmlTsCollection xml = new XmlTsCollection();
            INFO_MARSHALLER.marshal(v, xml);
            return xml;
        }
    }
}

