/*
 * Decompiled with CFR 0.152.
 */
package ec.demetra.xml.core;

import ec.demetra.xml.core.XmlTimeDomain;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TsDomainType", propOrder={"frequency", "firstYear", "firstPeriod", "length"})
public class XmlTsDomain
extends XmlTimeDomain {
    @XmlElement(name="Frequency")
    @XmlSchemaType(name="unsignedShort")
    protected int frequency;
    @XmlElement(name="FirstYear", required=true)
    @XmlSchemaType(name="gYear")
    protected int firstYear;
    @XmlElement(name="FirstPeriod")
    @XmlSchemaType(name="unsignedShort")
    protected Integer firstPeriod;
    @XmlElement(name="Length")
    @XmlSchemaType(name="unsignedInt")
    protected int length;
    private static final Adapter ADAPTER = new Adapter();

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int value) {
        this.frequency = value;
    }

    public int getFirstYear() {
        return this.firstYear;
    }

    public void setFirstYear(int value) {
        this.firstYear = value;
    }

    public Integer getFirstPeriod() {
        return this.firstPeriod;
    }

    public void setFirstPeriod(Integer value) {
        this.firstPeriod = value;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int value) {
        this.length = value;
    }

    public static Adapter getAdapter() {
        return ADAPTER;
    }

    public static class Adapter
    extends XmlAdapter<XmlTsDomain, TsDomain> {
        public TsDomain unmarshal(XmlTsDomain x) {
            TsPeriod p = new TsPeriod(TsFrequency.valueOf((int)x.frequency));
            if (x.firstPeriod != null) {
                p.set(x.firstYear, x.firstPeriod - 1);
            } else {
                p.set(x.firstYear, 0);
            }
            return new TsDomain(p, x.length);
        }

        public XmlTsDomain marshal(TsDomain v) {
            XmlTsDomain x = new XmlTsDomain();
            TsPeriod start = v.getStart();
            x.frequency = start.getFrequency().intValue();
            x.firstPeriod = x.frequency != 1 ? Integer.valueOf(start.getPosition() + 1) : null;
            x.firstYear = start.getYear();
            x.length = v.getLength();
            return x;
        }
    }
}

