/*
 * Decompiled with CFR 0.152.
 */
package ec.demetra.xml.processing;

import ec.demetra.xml.calendars.CalendarAdapters;
import ec.demetra.xml.calendars.XmlCalendar;
import ec.demetra.xml.calendars.XmlCalendars;
import ec.demetra.xml.regression.XmlTsVariables;
import ec.tss.xml.InPlaceXmlMarshaller;
import ec.tss.xml.InPlaceXmlUnmarshaller;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import ec.tstoolkit.timeseries.regression.TsVariables;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="ProcessingContext")
@XmlType(name="ProcessingContextType", propOrder={"variables", "calendars"})
public class XmlProcessingContext {
    @XmlElement(name="Variables", required=true)
    protected Variables variables;
    @XmlElement(name="Calendars", required=true)
    protected XmlCalendars calendars;
    public static final InPlaceXmlMarshaller<XmlProcessingContext, ProcessingContext> MARSHALLER = (v, xml) -> {
        int count;
        if (!v.getGregorianCalendars().isEmpty()) {
            xml.calendars = new XmlCalendars();
            String[] names = v.getGregorianCalendars().getNames();
            for (int i = 0; i < names.length; ++i) {
                IGregorianCalendarProvider cur = (IGregorianCalendarProvider)v.getGregorianCalendars().get(names[i]);
                XmlCalendar xcur = CalendarAdapters.getDefault().marshal(cur);
                if (xcur == null) continue;
                xcur.setName(names[i]);
                xml.calendars.getCalendars().add(xcur);
            }
        }
        if ((count = v.getTsVariableManagers().getCount()) > 0) {
            xml.variables = new Variables();
            for (String n : v.getTsVariableManagers().getNames()) {
                TsVariables cur = v.getTsVariables(n);
                if (cur.isEmpty()) continue;
                XmlTsVariables xcur = new XmlTsVariables();
                xcur.setName(n);
                XmlTsVariables.MARSHALLER.marshal(cur, xcur);
                xml.variables.getGroup().add(xcur);
            }
        }
        return true;
    };
    public static final InPlaceXmlUnmarshaller<XmlProcessingContext, ProcessingContext> UNMARSHALLER = (xml, v) -> {
        if (xml.calendars != null) {
            for (XmlCalendar xcal : xml.calendars.getCalendars()) {
                IGregorianCalendarProvider cal = CalendarAdapters.getDefault().unmarshal(xcal, v.getGregorianCalendars());
                v.getGregorianCalendars().set(xcal.getName(), (Object)cal);
            }
        }
        if (xml.variables != null) {
            for (XmlTsVariables xcur : xml.variables.getGroup()) {
                TsVariables vars = new TsVariables();
                XmlTsVariables.UNMARSHALLER.unmarshal(xcur, vars);
                v.getTsVariableManagers().set(xcur.getName(), (Object)vars);
            }
        }
        return true;
    };

    public Variables getVariables() {
        return this.variables;
    }

    public void setVariables(Variables value) {
        this.variables = value;
    }

    public XmlCalendars getCalendars() {
        return this.calendars;
    }

    public void setCalendars(XmlCalendars value) {
        this.calendars = value;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"group"})
    public static class Variables {
        @XmlElement(name="Group")
        private List<XmlTsVariables> group = new ArrayList<XmlTsVariables>();

        public List<XmlTsVariables> getGroup() {
            return this.group;
        }
    }
}

