/*
 * Decompiled with CFR 0.152.
 */
package ec.demetra.xml.regression;

import ec.demetra.xml.regression.TsModifierAdapter;
import ec.demetra.xml.regression.XmlRegressionVariableModifier;
import ec.tstoolkit.timeseries.regression.ITsModifier;
import internal.xml.regression.TsModifierAdapterLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class TsModifierAdapters {
    private static final AtomicReference<TsModifierAdapters> defadapters = new AtomicReference();
    private final List<TsModifierAdapter> adapters = new ArrayList<TsModifierAdapter>();

    public static final TsModifierAdapters getDefault() {
        defadapters.compareAndSet(null, TsModifierAdapters.make());
        return defadapters.get();
    }

    public static final void setDefault(TsModifierAdapters adapters) {
        defadapters.set(adapters);
    }

    private static TsModifierAdapters make() {
        TsModifierAdapters adapters = new TsModifierAdapters();
        adapters.load();
        return adapters;
    }

    public void load() {
        this.adapters.addAll(new TsModifierAdapterLoader().get());
    }

    public List<Class> getXmlClasses() {
        return this.adapters.stream().map(adapter -> adapter.getXmlType()).collect(Collectors.toList());
    }

    public ITsModifier unmarshal(XmlRegressionVariableModifier xvar) {
        for (TsModifierAdapter adapter : this.adapters) {
            if (!adapter.getXmlType().isInstance(xvar)) continue;
            try {
                return (ITsModifier)adapter.unmarshal(xvar);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public XmlRegressionVariableModifier marshal(ITsModifier ivar) {
        for (TsModifierAdapter adapter : this.adapters) {
            if (!adapter.getValueType().isInstance(ivar)) continue;
            try {
                return (XmlRegressionVariableModifier)adapter.marshal(ivar);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }
}

