/*
 * Decompiled with CFR 0.152.
 */
package ec.demetra.xml.regression;

import ec.demetra.xml.regression.TsVariableAdapter;
import ec.demetra.xml.regression.XmlRegressionVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import internal.xml.regression.TsVariableAdapterLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class TsVariableAdapters {
    private static final AtomicReference<TsVariableAdapters> defadapters = new AtomicReference();
    private final List<TsVariableAdapter> adapters = new ArrayList<TsVariableAdapter>();

    public static final TsVariableAdapters getDefault() {
        defadapters.compareAndSet(null, new TsVariableAdapters());
        return defadapters.get();
    }

    public static final void setDefault(TsVariableAdapters adapters) {
        defadapters.set(adapters);
    }

    public TsVariableAdapters() {
        this.load();
    }

    public TsVariableAdapters(TsVariableAdapter ... adapters) {
        for (int i = 0; i < adapters.length; ++i) {
            this.adapters.add(adapters[i]);
        }
    }

    private void load() {
        this.adapters.addAll(new TsVariableAdapterLoader().get());
    }

    public List<Class> getXmlClasses() {
        return this.adapters.stream().map(adapter -> adapter.getXmlType()).collect(Collectors.toList());
    }

    public ITsVariable unmarshal(XmlRegressionVariable xvar) {
        for (TsVariableAdapter adapter : this.adapters) {
            if (!adapter.getXmlType().isInstance(xvar)) continue;
            try {
                return (ITsVariable)adapter.unmarshal(xvar);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public XmlRegressionVariable marshal(ITsVariable ivar) {
        for (TsVariableAdapter adapter : this.adapters) {
            if (!adapter.getImplementationType().isInstance(ivar)) continue;
            try {
                return (XmlRegressionVariable)adapter.marshal(ivar);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }
}

