/*
 * Decompiled with CFR 0.152.
 */
package ec.demetra.xml.regression;

import ec.demetra.xml.regression.TsVariableAdapter;
import ec.demetra.xml.regression.XmlRegressionVariable;
import ec.demetra.xml.regression.XmlSpan;
import ec.tstoolkit.timeseries.regression.InterventionVariable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="InterventionVariableType", propOrder={"sequence", "deltaFilter", "deltaSeasonalFilter"})
public class XmlInterventionVariable
extends XmlRegressionVariable {
    @XmlElement(name="Sequence")
    protected List<XmlSpan> sequence;
    @XmlElement(name="DeltaFilter")
    protected Double deltaFilter;
    @XmlElement(name="DeltaSeasonalFilter")
    protected Double deltaSeasonalFilter;
    private static final Adapter ADAPTER = new Adapter();

    public List<XmlSpan> getSequences() {
        if (this.sequence == null) {
            this.sequence = new ArrayList<XmlSpan>();
        }
        return this.sequence;
    }

    public Double getDeltaFilter() {
        return this.deltaFilter;
    }

    public void setDeltaFilter(Double value) {
        this.deltaFilter = value != null && value == 0.0 ? null : value;
    }

    public Double getDeltaSeasonalFilter() {
        return this.deltaSeasonalFilter;
    }

    public void setDeltaSeasonalFilter(Double value) {
        this.deltaSeasonalFilter = value != null && value == 0.0 ? null : value;
    }

    public static final Adapter getAdapter() {
        return ADAPTER;
    }

    public static class Adapter
    extends TsVariableAdapter<XmlInterventionVariable, InterventionVariable> {
        @Override
        public Class<InterventionVariable> getImplementationType() {
            return InterventionVariable.class;
        }

        @Override
        public Class<XmlInterventionVariable> getXmlType() {
            return XmlInterventionVariable.class;
        }

        public InterventionVariable unmarshal(XmlInterventionVariable v) {
            if (v.sequence == null || v.sequence.isEmpty()) {
                return null;
            }
            InterventionVariable ivar = new InterventionVariable();
            if (v.deltaFilter != null) {
                ivar.setDelta(v.deltaFilter.doubleValue());
            }
            if (v.deltaSeasonalFilter != null) {
                ivar.setDeltaS(v.deltaSeasonalFilter.doubleValue());
            }
            for (XmlSpan seq : v.sequence) {
                ivar.add(seq.from, seq.to);
            }
            return ivar;
        }

        public XmlInterventionVariable marshal(InterventionVariable t) {
            XmlInterventionVariable xml = new XmlInterventionVariable();
            xml.setDeltaFilter(t.getDelta());
            xml.setDeltaSeasonalFilter(t.getDeltaS());
            List<XmlSpan> sequences = xml.getSequences();
            int n = t.getCount();
            for (int i = 0; i < n; ++i) {
                XmlSpan span = new XmlSpan();
                span.setFrom(t.getSequence((int)i).start);
                span.setTo(t.getSequence((int)i).end);
                sequences.add(span);
            }
            return xml;
        }
    }
}

