/*
 * Decompiled with CFR 0.152.
 */
package ec.demetra.xml.sa.tramoseats;

import ec.demetra.xml.core.XmlInformationSet;
import ec.demetra.xml.core.XmlTs;
import ec.demetra.xml.processing.XmlProcessingContext;
import ec.demetra.xml.sa.tramoseats.XmlTramoAtomicRequest;
import ec.demetra.xml.sa.tramoseats.XmlTramoRequest;
import ec.demetra.xml.sa.tramoseats.XmlTramoRequests;
import ec.demetra.xml.sa.tramoseats.XmlTramoSeatsAtomicRequest;
import ec.demetra.xml.sa.tramoseats.XmlTramoSeatsRequest;
import ec.demetra.xml.sa.tramoseats.XmlTramoSeatsRequests;
import ec.demetra.xml.sa.tramoseats.XmlTramoSeatsSpecification;
import ec.demetra.xml.sa.tramoseats.XmlTramoSpecification;
import ec.satoolkit.algorithm.implementation.TramoSeatsProcessingFactory;
import ec.satoolkit.tramoseats.TramoSeatsSpecification;
import ec.tss.Ts;
import ec.tss.TsInformationType;
import ec.tss.TsStatus;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.algorithm.SequentialProcessing;
import ec.tstoolkit.algorithm.implementation.TramoProcessingFactory;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetHelper;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.tramo.TramoSpecification;
import ec.tstoolkit.utilities.NamedObject;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TramoSeatsXmlProcessor {
    private static final String[] DEF_SA = new String[]{"final.y", "final.t", "final.s", "final.i", "final.sa", "final.ycal", "final.y_f", "final.t_f", "final.s_f", "final.i_f", "final.sa_f"};

    public XmlInformationSet process(XmlTramoRequest request) {
        TramoSpecification spec = TramoSeatsXmlProcessor.specification(request);
        Ts s = XmlTs.TS_UNMARSHALLER.unmarshal(request.series);
        if (s == null) {
            return null;
        }
        if (s.hasData() == TsStatus.Undefined) {
            s.load(TsInformationType.Data);
        }
        if (spec == null || s.getTsData() == null) {
            return null;
        }
        ProcessingContext ctx = TramoSeatsXmlProcessor.context(request.context);
        IProcessing processing = TramoProcessingFactory.instance.generateProcessing(spec, ctx);
        PreprocessingModel model = (PreprocessingModel)processing.process((Object)s.getTsData());
        TreeSet<String> set = new TreeSet<String>();
        List<String> items = request.getOutputFilter();
        set.addAll(items);
        InformationSet info = InformationSetHelper.fromProcResults((IProcResults)model, set);
        XmlInformationSet xinfo = new XmlInformationSet();
        if (request.getFlat()) {
            xinfo.flatCopy(info);
        } else {
            xinfo.copy(info);
        }
        return xinfo;
    }

    public XmlInformationSet process(XmlTramoSeatsRequest request) {
        TramoSeatsSpecification spec = TramoSeatsXmlProcessor.specification(request);
        Ts s = XmlTs.TS_UNMARSHALLER.unmarshal(request.series);
        if (s == null) {
            return null;
        }
        if (s.hasData() == TsStatus.Undefined) {
            s.load(TsInformationType.Data);
        }
        if (spec == null || s.getTsData() == null) {
            return null;
        }
        ProcessingContext ctx = TramoSeatsXmlProcessor.context(request.context);
        SequentialProcessing processing = TramoSeatsProcessingFactory.instance.generateProcessing(spec, ctx);
        CompositeResults rslt = processing.process((Object)s.getTsData());
        TreeSet<String> set = new TreeSet<String>();
        if (request.outputFilter != null) {
            List<String> items = request.getOutputFilter();
            set.addAll(items);
        } else {
            for (int i = 0; i < DEF_SA.length; ++i) {
                set.add(DEF_SA[i]);
            }
        }
        InformationSet info = InformationSetHelper.fromProcResults((IProcResults)rslt, set);
        XmlInformationSet xinfo = new XmlInformationSet();
        if (request.getFlat()) {
            xinfo.flatCopy(info);
        } else {
            xinfo.copy(info);
        }
        return xinfo;
    }

    public XmlInformationSet process(XmlTramoRequests request) {
        ProcessingContext ctx = TramoSeatsXmlProcessor.context(request.context);
        request.checkNames();
        Stream stream = request.getParallelProcessing() ? request.getItems().parallelStream() : request.getItems().stream();
        List models = stream.map(o -> {
            try {
                TramoSpecification spec = TramoSeatsXmlProcessor.specification(o);
                Ts s = XmlTs.TS_UNMARSHALLER.unmarshal(o.series);
                if (s == null) {
                    return null;
                }
                if (s.hasData() == TsStatus.Undefined) {
                    s.load(TsInformationType.Data);
                }
                if (spec == null || s.getTsData() == null) {
                    return null;
                }
                IProcessing processing = TramoProcessingFactory.instance.generateProcessing(spec, ctx);
                PreprocessingModel model = (PreprocessingModel)processing.process((Object)s.getTsData());
                String name = s.getRawName();
                return new NamedObject(name, (Object)model);
            }
            catch (Exception err) {
                return null;
            }
        }).collect(Collectors.toList());
        TreeSet<String> set = new TreeSet<String>();
        List<String> items = request.getOutputFilter();
        set.addAll(items);
        InformationSet infos = new InformationSet();
        for (NamedObject cur : models) {
            if (cur == null) continue;
            InformationSet info = InformationSetHelper.fromProcResults((IProcResults)((IProcResults)cur.object), set);
            infos.add(cur.name, (Object)info);
        }
        XmlInformationSet xinfo = new XmlInformationSet();
        if (request.getFlat()) {
            xinfo.flatCopy(infos);
        } else {
            xinfo.copy(infos);
        }
        return xinfo;
    }

    public XmlInformationSet process(XmlTramoSeatsRequests request) {
        request.checkNames();
        ProcessingContext ctx = TramoSeatsXmlProcessor.context(request.context);
        Stream stream = request.getParallelProcessing() ? request.getItems().parallelStream() : request.getItems().stream();
        List models = stream.map(o -> {
            try {
                TramoSeatsSpecification spec = TramoSeatsXmlProcessor.specification(o);
                Ts s = XmlTs.TS_UNMARSHALLER.unmarshal(o.series);
                if (s == null) {
                    return null;
                }
                if (s.hasData() == TsStatus.Undefined) {
                    s.load(TsInformationType.Data);
                }
                if (spec == null || s.getTsData() == null) {
                    return null;
                }
                SequentialProcessing processing = TramoSeatsProcessingFactory.instance.generateProcessing(spec, ctx);
                CompositeResults rslt = processing.process((Object)s.getTsData());
                return new NamedObject(s.getRawName(), (Object)rslt);
            }
            catch (Exception err) {
                return null;
            }
        }).collect(Collectors.toList());
        TreeSet<String> set = new TreeSet<String>();
        if (request.outputFilter != null) {
            List<String> items = request.getOutputFilter();
            set.addAll(items);
        } else {
            for (int i = 0; i < DEF_SA.length; ++i) {
                set.add(DEF_SA[i]);
            }
        }
        InformationSet infos = new InformationSet();
        for (NamedObject cur : models) {
            if (cur == null) continue;
            InformationSet info = InformationSetHelper.fromProcResults((IProcResults)((IProcResults)cur.object), set);
            infos.add(cur.name, (Object)info);
        }
        XmlInformationSet xinfo = new XmlInformationSet();
        if (request.getFlat()) {
            xinfo.flatCopy(infos);
        } else {
            xinfo.copy(infos);
        }
        return xinfo;
    }

    public static TramoSpecification specification(XmlTramoAtomicRequest request) {
        if (request.defaultSpecification != null) {
            return TramoSpecification.fromString((String)request.defaultSpecification);
        }
        TramoSpecification spec = new TramoSpecification();
        XmlTramoSpecification.UNMARSHALLER.unmarshal(request.specification, spec);
        return spec;
    }

    public static ProcessingContext context(XmlProcessingContext ctx) {
        if (ctx == null) {
            return ProcessingContext.getActiveContext();
        }
        ProcessingContext c = new ProcessingContext();
        XmlProcessingContext.UNMARSHALLER.unmarshal(ctx, c);
        return c;
    }

    public static TramoSeatsSpecification specification(XmlTramoSeatsAtomicRequest request) {
        if (request.defaultSpecification != null) {
            return TramoSeatsSpecification.fromString((String)request.defaultSpecification);
        }
        TramoSeatsSpecification spec = new TramoSeatsSpecification();
        XmlTramoSeatsSpecification.UNMARSHALLER.unmarshal(request.specification, spec);
        return spec;
    }
}

