/*
 * Decompiled with CFR 0.152.
 */
package ec.demetra.xml.sa.x13;

import ec.demetra.xml.core.XmlInformationSet;
import ec.demetra.xml.core.XmlTs;
import ec.demetra.xml.processing.XmlProcessingContext;
import ec.demetra.xml.sa.x13.XmlRegArimaAtomicRequest;
import ec.demetra.xml.sa.x13.XmlRegArimaRequest;
import ec.demetra.xml.sa.x13.XmlRegArimaRequests;
import ec.demetra.xml.sa.x13.XmlRegArimaSpecification;
import ec.demetra.xml.sa.x13.XmlX13AtomicRequest;
import ec.demetra.xml.sa.x13.XmlX13Request;
import ec.demetra.xml.sa.x13.XmlX13Requests;
import ec.demetra.xml.sa.x13.XmlX13Specification;
import ec.satoolkit.algorithm.implementation.X13ProcessingFactory;
import ec.satoolkit.x13.X13Specification;
import ec.tss.Ts;
import ec.tss.TsInformationType;
import ec.tss.TsStatus;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.algorithm.SequentialProcessing;
import ec.tstoolkit.algorithm.implementation.RegArimaProcessingFactory;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetHelper;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.x13.RegArimaSpecification;
import ec.tstoolkit.utilities.NamedObject;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class X13XmlProcessor {
    private static final String[] DEF_SA = new String[]{"final.y", "final.t", "final.s", "final.i", "final.sa", "final.ycal", "final.y_f", "final.t_f", "final.s_f", "final.i_f", "final.sa_f"};

    public XmlInformationSet process(XmlRegArimaRequest request) {
        RegArimaSpecification spec = X13XmlProcessor.specification(request);
        Ts s = XmlTs.TS_UNMARSHALLER.unmarshal(request.series);
        if (s == null) {
            return null;
        }
        if (s.hasData() == TsStatus.Undefined) {
            s.load(TsInformationType.Data);
        }
        if (spec == null || s.getTsData() == null) {
            return null;
        }
        ProcessingContext ctx = X13XmlProcessor.context(request.context);
        IProcessing processing = RegArimaProcessingFactory.instance.generateProcessing(spec, ctx);
        PreprocessingModel model = (PreprocessingModel)processing.process((Object)s.getTsData());
        TreeSet<String> set = new TreeSet<String>();
        List<String> items = request.getOutputFilter();
        set.addAll(items);
        InformationSet info = InformationSetHelper.fromProcResults((IProcResults)model, set);
        XmlInformationSet xinfo = new XmlInformationSet();
        if (request.getFlat()) {
            xinfo.flatCopy(info);
        } else {
            xinfo.copy(info);
        }
        return xinfo;
    }

    public XmlInformationSet process(XmlX13Request request) {
        X13Specification spec = X13XmlProcessor.specification(request);
        Ts s = XmlTs.TS_UNMARSHALLER.unmarshal(request.series);
        if (s == null) {
            return null;
        }
        if (s.hasData() == TsStatus.Undefined) {
            s.load(TsInformationType.Data);
        }
        if (spec == null || s.getTsData() == null) {
            return null;
        }
        ProcessingContext ctx = X13XmlProcessor.context(request.context);
        SequentialProcessing processing = X13ProcessingFactory.instance.generateProcessing(spec, ctx);
        CompositeResults rslt = processing.process((Object)s.getTsData());
        TreeSet<String> set = new TreeSet<String>();
        if (request.outputFilter != null) {
            List<String> items = request.getOutputFilter();
            set.addAll(items);
        } else {
            for (int i = 0; i < DEF_SA.length; ++i) {
                set.add(DEF_SA[i]);
            }
        }
        InformationSet info = InformationSetHelper.fromProcResults((IProcResults)rslt, set);
        XmlInformationSet xinfo = new XmlInformationSet();
        if (request.getFlat()) {
            xinfo.flatCopy(info);
        } else {
            xinfo.copy(info);
        }
        return xinfo;
    }

    public XmlInformationSet process(XmlRegArimaRequests request) {
        ProcessingContext ctx = X13XmlProcessor.context(request.context);
        request.checkNames();
        Stream stream = request.getParallelProcessing() ? request.getItems().parallelStream() : request.getItems().stream();
        List models = stream.map(o -> {
            try {
                RegArimaSpecification spec = X13XmlProcessor.specification(o);
                Ts s = XmlTs.TS_UNMARSHALLER.unmarshal(o.series);
                if (s == null) {
                    return null;
                }
                if (s.hasData() == TsStatus.Undefined) {
                    s.load(TsInformationType.Data);
                }
                if (spec == null || s.getTsData() == null) {
                    return null;
                }
                IProcessing processing = RegArimaProcessingFactory.instance.generateProcessing(spec, ctx);
                PreprocessingModel model = (PreprocessingModel)processing.process((Object)s.getTsData());
                return new NamedObject(s.getRawName(), (Object)model);
            }
            catch (Exception err) {
                return null;
            }
        }).collect(Collectors.toList());
        TreeSet<String> set = new TreeSet<String>();
        List<String> items = request.getOutputFilter();
        set.addAll(items);
        InformationSet infos = new InformationSet();
        for (NamedObject cur : models) {
            if (cur == null) continue;
            InformationSet info = InformationSetHelper.fromProcResults((IProcResults)((IProcResults)cur.object), set);
            infos.add(cur.name, (Object)info);
        }
        XmlInformationSet xinfo = new XmlInformationSet();
        if (request.getFlat()) {
            xinfo.flatCopy(infos);
        } else {
            xinfo.copy(infos);
        }
        return xinfo;
    }

    public XmlInformationSet process(XmlX13Requests request) {
        ProcessingContext ctx = X13XmlProcessor.context(request.context);
        request.checkNames();
        Stream stream = request.getParallelProcessing() ? request.getItems().parallelStream() : request.getItems().stream();
        List models = stream.map(o -> {
            try {
                X13Specification spec = X13XmlProcessor.specification(o);
                Ts s = XmlTs.TS_UNMARSHALLER.unmarshal(o.series);
                if (s == null) {
                    return null;
                }
                if (s.hasData() == TsStatus.Undefined) {
                    s.load(TsInformationType.Data);
                }
                if (spec == null || s.getTsData() == null) {
                    return null;
                }
                SequentialProcessing processing = X13ProcessingFactory.instance.generateProcessing(spec, ctx);
                CompositeResults rslt = processing.process((Object)s.getTsData());
                return new NamedObject(s.getRawName(), (Object)rslt);
            }
            catch (Exception err) {
                return null;
            }
        }).collect(Collectors.toList());
        TreeSet<String> set = new TreeSet<String>();
        if (request.outputFilter != null) {
            List<String> items = request.getOutputFilter();
            set.addAll(items);
        } else {
            for (int i = 0; i < DEF_SA.length; ++i) {
                set.add(DEF_SA[i]);
            }
        }
        InformationSet infos = new InformationSet();
        for (NamedObject cur : models) {
            if (cur == null) continue;
            InformationSet info = InformationSetHelper.fromProcResults((IProcResults)((IProcResults)cur.object), set);
            infos.add(cur.name, (Object)info);
        }
        XmlInformationSet xinfo = new XmlInformationSet();
        if (request.getFlat()) {
            xinfo.flatCopy(infos);
        } else {
            xinfo.copy(infos);
        }
        return xinfo;
    }

    public static RegArimaSpecification specification(XmlRegArimaAtomicRequest request) {
        if (request.defaultSpecification != null) {
            return RegArimaSpecification.fromString((String)request.defaultSpecification);
        }
        RegArimaSpecification spec = new RegArimaSpecification();
        XmlRegArimaSpecification.UNMARSHALLER.unmarshal(request.specification, spec);
        return spec;
    }

    public static ProcessingContext context(XmlProcessingContext ctx) {
        if (ctx == null) {
            return ProcessingContext.getActiveContext();
        }
        ProcessingContext c = new ProcessingContext();
        XmlProcessingContext.UNMARSHALLER.unmarshal(ctx, c);
        return c;
    }

    public static X13Specification specification(XmlX13AtomicRequest request) {
        if (request.defaultSpecification != null) {
            return X13Specification.fromString((String)request.defaultSpecification);
        }
        X13Specification spec = new X13Specification();
        XmlX13Specification.UNMARSHALLER.unmarshal(request.specification, spec);
        return spec;
    }
}

