/*
 * Decompiled with CFR 0.152.
 */
package ec.demetra.xml.sa.x13;

import ec.demetra.xml.core.XmlPeriodSelection;
import ec.demetra.xml.modelling.XmlOutlierSpec;
import ec.demetra.xml.sa.x13.XmlSingleOutlierSpec;
import ec.tss.xml.IXmlMarshaller;
import ec.tss.xml.InPlaceXmlUnmarshaller;
import ec.tstoolkit.modelling.arima.x13.OutlierSpec;
import ec.tstoolkit.modelling.arima.x13.SingleOutlierSpec;
import ec.tstoolkit.timeseries.PeriodSelectorType;
import ec.tstoolkit.timeseries.regression.OutlierType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="OutlierSpecType", propOrder={"types", "criticalValue", "outlier", "deltaTC", "method"})
public class XmlOutliersSpec
extends XmlOutlierSpec {
    @XmlList
    @XmlElement(name="Types", required=true)
    @XmlSchemaType(name="NMTOKENS")
    protected List<String> types;
    @XmlElement(name="CriticalValue")
    protected Double criticalValue;
    @XmlElement(name="Outlier")
    protected List<XmlSingleOutlierSpec> outlier;
    @XmlElement(name="DeltaTC", defaultValue="0.7")
    protected Double deltaTC;
    @XmlElement(name="Method")
    protected OutlierSpec.Method method;
    public static final InPlaceXmlUnmarshaller<XmlOutliersSpec, OutlierSpec> UNMARSHALLER = (xml, v) -> {
        if (xml.span != null) {
            XmlPeriodSelection.UNMARSHALLER.unmarshal(xml.span, v.getSpan());
        } else {
            v.getSpan().all();
        }
        if (xml.types != null && !xml.types.isEmpty()) {
            if (xml.criticalValue != null) {
                v.setDefaultCriticalValue(xml.criticalValue.doubleValue());
            }
            xml.types.stream().forEach(o -> v.add(OutlierType.valueOf((String)o)));
        } else if (xml.outlier != null) {
            for (XmlSingleOutlierSpec xcur : xml.outlier) {
                SingleOutlierSpec cur = new SingleOutlierSpec();
                cur.setType(OutlierType.valueOf((String)xcur.type));
                if (xcur.criticalValue != null) {
                    cur.setCriticalValue(xcur.criticalValue.doubleValue());
                }
                v.add(cur);
            }
        }
        if (xml.deltaTC != null) {
            v.setMonthlyTCRate(xml.deltaTC.doubleValue());
        }
        if (xml.method != null) {
            v.setMethod(xml.method);
        }
        return true;
    };
    public static final IXmlMarshaller<XmlOutliersSpec, OutlierSpec> MARSHALLER = v -> {
        if (!v.isUsed()) {
            return null;
        }
        XmlOutliersSpec xml = new XmlOutliersSpec();
        if (v.getSpan().getType() != PeriodSelectorType.All) {
            xml.span = new XmlPeriodSelection();
            XmlPeriodSelection.MARSHALLER.marshal(v.getSpan(), xml.span);
        }
        xml.setCriticalValue(v.getDefaultCriticalValue());
        xml.setDeltaTC(v.getMonthlyTCRate());
        SingleOutlierSpec[] otypes = v.getTypes();
        double va = otypes[0].getCriticalValue();
        boolean same = true;
        for (int i = 1; i < otypes.length; ++i) {
            if (otypes[i].getCriticalValue() == va) continue;
            same = false;
            break;
        }
        if (same) {
            List<String> stypes = xml.getTypes();
            for (int i = 0; i < otypes.length; ++i) {
                stypes.add(otypes[i].getType().name());
            }
        } else {
            List<XmlSingleOutlierSpec> xtypes = xml.getOutliers();
            for (int i = 0; i < otypes.length; ++i) {
                XmlSingleOutlierSpec xcur = new XmlSingleOutlierSpec();
                xcur.type = otypes[i].getType().name();
                xcur.criticalValue = otypes[i].getCriticalValue();
                xtypes.add(xcur);
            }
        }
        return xml;
    };

    public List<String> getTypes() {
        if (this.types == null) {
            this.types = new ArrayList<String>();
        }
        return this.types;
    }

    public Double getCriticalValue() {
        return this.criticalValue;
    }

    public void setCriticalValue(Double value) {
        this.criticalValue = value != null && value == 0.0 ? null : value;
    }

    public double getDeltaTC() {
        return this.deltaTC == null ? 0.7 : this.deltaTC;
    }

    public void setDeltaTC(Double value) {
        this.deltaTC = value != null && value == 0.7 ? null : value;
    }

    public List<XmlSingleOutlierSpec> getOutliers() {
        if (this.outlier == null) {
            this.outlier = new ArrayList<XmlSingleOutlierSpec>();
        }
        return this.outlier;
    }

    public OutlierSpec.Method getMethod() {
        return this.method;
    }

    public void setMethod(OutlierSpec.Method method) {
        this.method = method != null && method == OutlierSpec.Method.AddOne ? null : method;
    }
}

