/*
 * Decompiled with CFR 0.152.
 */
package ec.demetra.xml.sa.x13;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.x11.CalendarSigma;
import ec.satoolkit.x11.SeasonalFilterOption;
import ec.satoolkit.x11.SigmavecOption;
import ec.satoolkit.x11.X11Specification;
import ec.tss.xml.InPlaceXmlMarshaller;
import ec.tss.xml.InPlaceXmlUnmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="X11SpecType", propOrder={"mode", "seasonal", "forecasts", "backcasts", "lowerSigma", "upperSigma", "seasonalMA", "trendMA", "calendarSigma", "sigmaVec", "excludeForecasts"})
public class XmlX11Spec {
    @XmlElement(name="Mode", required=true)
    @XmlSchemaType(name="NMTOKEN")
    protected DecompositionMode mode;
    @XmlElement(name="Seasonal", defaultValue="true")
    protected Boolean seasonal;
    @XmlElement(name="Forecasts", defaultValue="-1")
    protected Integer forecasts;
    @XmlElement(name="Backcasts", defaultValue="0")
    protected Integer backcasts;
    @XmlElement(name="LowerSigma", defaultValue="1.5")
    protected Double lowerSigma;
    @XmlElement(name="UpperSigma", defaultValue="2.5")
    protected Double upperSigma;
    @XmlElement(name="SeasonalMA")
    protected SeasonalMA seasonalMA;
    @XmlElement(name="TrendMA")
    protected Integer trendMA;
    @XmlElement(name="CalendarSigma")
    @XmlSchemaType(name="NMTOKEN")
    protected CalendarSigma calendarSigma;
    @XmlList
    @XmlElement(name="SigmaVec", type=Integer.class)
    protected int[] sigmaVec;
    @XmlElement(name="ExcludeForecasts", defaultValue="false")
    protected Boolean excludeForecasts;
    public static final InPlaceXmlMarshaller<XmlX11Spec, X11Specification> MARSHALLER = (v, xml) -> {
        CalendarSigma cs;
        if (v.isDefault()) {
            return true;
        }
        xml.setMode(v.getMode());
        xml.setForecasts(v.getForecastHorizon());
        xml.setLowerSigma(v.getLowerSigma());
        xml.setUpperSigma(v.getUpperSigma());
        xml.setTrendMA(v.getHendersonFilterLength());
        xml.setExcludeForecasts(v.isExcludefcst());
        xml.setSeasonal(v.isSeasonal());
        SeasonalFilterOption[] seasonalFilters = v.getSeasonalFilters();
        if (seasonalFilters != null) {
            SeasonalMA sma = new SeasonalMA();
            if (seasonalFilters.length == 1) {
                sma.filter = seasonalFilters[0];
            } else {
                sma.filters = seasonalFilters;
            }
            xml.setSeasonalMA(sma);
        }
        if ((cs = v.getCalendarSigma()) != CalendarSigma.None) {
            xml.setCalendarSigma(cs);
            if (cs == CalendarSigma.Select) {
                xml.setSigmaVec(XmlX11Spec.convert(v.getSigmavec()));
            }
        }
        return true;
    };
    public static final InPlaceXmlUnmarshaller<XmlX11Spec, X11Specification> UNMARSHALLER = (xml, v) -> {
        if (xml.mode != null) {
            v.setMode(xml.mode);
        }
        if (xml.forecasts != null) {
            v.setForecastHorizon(xml.forecasts.intValue());
        }
        if (xml.trendMA != null) {
            v.setHendersonFilterLength(xml.trendMA.intValue());
        }
        if (xml.seasonal != null) {
            v.setSeasonal(xml.seasonal.booleanValue());
        }
        if (xml.excludeForecasts != null) {
            v.setExcludefcst(xml.excludeForecasts.booleanValue());
        }
        if (xml.seasonalMA != null) {
            if (xml.seasonalMA.filter != null) {
                v.setSeasonalFilter(xml.seasonalMA.filter);
            } else if (xml.seasonalMA.filters != null) {
                v.setSeasonalFilters(xml.seasonalMA.filters);
            }
        }
        if (xml.lowerSigma != null) {
            v.setLowerSigma(xml.lowerSigma.doubleValue());
        }
        if (xml.upperSigma != null) {
            v.setUpperSigma(xml.upperSigma.doubleValue());
        }
        if (xml.calendarSigma != null) {
            v.setCalendarSigma(xml.calendarSigma);
            if (xml.sigmaVec != null) {
                v.setSigmavec(XmlX11Spec.convert(xml.sigmaVec));
            }
        }
        return true;
    };

    public DecompositionMode getMode() {
        return this.mode;
    }

    public void setMode(DecompositionMode value) {
        this.mode = value;
    }

    public Boolean isSeasonal() {
        return this.seasonal;
    }

    public void setSeasonal(Boolean value) {
        this.seasonal = value != null && value != false ? null : value;
    }

    public Integer getForecasts() {
        return this.forecasts;
    }

    public void setForecasts(Integer value) {
        this.forecasts = value != null && value == -1 ? null : value;
    }

    public Integer getBackcasts() {
        return this.backcasts;
    }

    public void setBackcasts(Integer value) {
        if (value != null && value == 0) {
            this.forecasts = null;
        } else {
            this.backcasts = value;
        }
    }

    public Double getLowerSigma() {
        return this.lowerSigma;
    }

    public void setLowerSigma(Double value) {
        this.lowerSigma = value != null && value == 1.5 ? null : value;
    }

    public Double getUpperSigma() {
        return this.upperSigma;
    }

    public void setUpperSigma(Double value) {
        this.upperSigma = value != null && value == 2.5 ? null : value;
    }

    public SeasonalMA getSeasonalMA() {
        return this.seasonalMA;
    }

    public void setSeasonalMA(SeasonalMA value) {
        this.seasonalMA = value;
    }

    public Integer getTrendMA() {
        return this.trendMA;
    }

    public void setTrendMA(Integer value) {
        this.trendMA = value != null && value == 0 ? null : value;
    }

    public CalendarSigma getCalendarSigma() {
        return this.calendarSigma;
    }

    public void setCalendarSigma(CalendarSigma value) {
        this.calendarSigma = value;
    }

    public int[] getSigmaVec() {
        return this.sigmaVec;
    }

    public void setSigmaVec(int[] value) {
        this.sigmaVec = value;
    }

    public Boolean isExcludeForecasts() {
        return this.excludeForecasts;
    }

    public void setExcludeForecasts(Boolean value) {
        this.excludeForecasts = value != null && value == false ? null : value;
    }

    private static int[] convert(SigmavecOption[] sv) {
        if (sv == null) {
            return null;
        }
        int[] v = new int[sv.length];
        for (int i = 0; i < sv.length; ++i) {
            v[i] = sv[i] == SigmavecOption.Group1 ? 1 : 2;
        }
        return v;
    }

    private static SigmavecOption[] convert(int[] v) {
        if (v == null) {
            return null;
        }
        SigmavecOption[] sv = new SigmavecOption[v.length];
        for (int i = 0; i < v.length; ++i) {
            sv[i] = v[i] == 1 ? SigmavecOption.Group1 : SigmavecOption.Group2;
        }
        return sv;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"filter", "filters"})
    public static class SeasonalMA {
        @XmlElement(name="Filter")
        @XmlSchemaType(name="NMTOKEN")
        protected SeasonalFilterOption filter;
        @XmlList
        @XmlElement(name="Filters")
        protected SeasonalFilterOption[] filters;

        public SeasonalFilterOption getFilter() {
            return this.filter;
        }

        public void setFilter(SeasonalFilterOption value) {
            this.filter = value;
        }

        public SeasonalFilterOption[] getFilters() {
            return this.filters;
        }

        public void setFilters(SeasonalFilterOption[] value) {
            this.filters = value;
        }
    }
}

