/*
 * Decompiled with CFR 0.152.
 */
package ec.tss;

import ec.tss.Ts;
import ec.tss.TsFactory;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tstoolkit.information.InformationConverter;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.regression.TsVariable;
import ec.tstoolkit.timeseries.regression.TsVariables;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.utilities.IDynamicObject;

public class DynamicTsVariable
extends TsVariable
implements IDynamicObject {
    private final TsMoniker moniker_;
    private static final InformationConverter<DynamicTsVariable> tsvar = new DynamicTsVariableConverter();

    private static Ts fromMoniker(TsMoniker moniker) {
        return TsFactory.instance.createTs(null, moniker, TsInformationType.Data);
    }

    public DynamicTsVariable(String desc, TsMoniker moniker, TsData data) {
        super(desc, data);
        this.moniker_ = moniker;
    }

    public DynamicTsVariable(String desc, TsMoniker moniker) {
        super(desc, DynamicTsVariable.fromMoniker(moniker).getTsData());
        this.moniker_ = moniker;
    }

    public TsMoniker getMoniker() {
        return this.moniker_;
    }

    public boolean refresh() {
        Ts ts = DynamicTsVariable.fromMoniker(this.moniker_);
        if (ts.getTsData() == null) {
            return false;
        }
        this.setDescription(ts.getName());
        this.setData(ts.getTsData());
        return true;
    }

    public static void register() {
        TsVariables.LINKER.register("dynamic time series", DynamicTsVariable.class, tsvar);
    }

    private static class DynamicTsVariableConverter
    implements InformationConverter<DynamicTsVariable> {
        static final String TYPE = "dynamic time series";
        static final String MONIKER = "moniker";
        static final String DATA = "data";
        static final String DESC = "description";

        private DynamicTsVariableConverter() {
        }

        public DynamicTsVariable decode(InformationSet info) {
            TsMoniker moniker = (TsMoniker)info.get(MONIKER, TsMoniker.class);
            TsData data = (TsData)info.get(DATA, TsData.class);
            String desc = (String)info.get(DESC, String.class);
            return new DynamicTsVariable(desc, moniker, data);
        }

        public InformationSet encode(DynamicTsVariable t, boolean verbose) {
            InformationSet info = new InformationSet();
            info.set(MONIKER, (Object)t.getMoniker());
            info.set(DATA, (Object)t.getTsData());
            info.set(DESC, (Object)t.getDescription());
            return info;
        }

        public Class<DynamicTsVariable> getInformationType() {
            return DynamicTsVariable.class;
        }

        public String getTypeDescription() {
            return TYPE;
        }
    }
}

