/*
 * Decompiled with CFR 0.152.
 */
package ec.tss;

import com.google.common.base.Strings;
import ec.tss.ITsIdentified;
import ec.tss.TsFactory;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tss.TsStatus;
import ec.tstoolkit.IDocumented;
import ec.tstoolkit.MetaData;
import ec.tstoolkit.design.Internal;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.text.ParseException;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Ts
implements IDocumented,
ITsIdentified {
    public static final String SOURCE_OLD = "tsmoniker.source";
    public static final String ID_OLD = "tsmoniker.id";
    public static final String DYNAMIC = "dynamic";
    public static final String BEG = "@beg";
    public static final String END = "@end";
    public static final String CONFIDENTIAL = "@confidential";
    private final String m_name;

    protected Ts(String name) {
        this.m_name = Strings.nullToEmpty((String)name);
    }

    public final String getRawName() {
        return this.m_name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public abstract Ts freeze();

    public abstract TsInformationType getInformationType();

    public abstract TsStatus hasMetaData();

    public abstract TsStatus hasData();

    public abstract TsData getTsData();

    public abstract boolean isFrozen();

    public abstract boolean set(MetaData var1);

    public abstract boolean set(TsData var1);

    public abstract boolean set(TsData var1, MetaData var2);

    public abstract Ts unfreeze();

    public abstract boolean load(TsInformationType var1);

    public abstract boolean query(TsInformationType var1);

    public abstract boolean reload(TsInformationType var1);

    abstract Master getMaster();

    public abstract String getInvalidDataCause();

    public abstract void setInvalidDataCause(String var1);

    public abstract @NonNull TsInformation toInfo(@NonNull TsInformationType var1);

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName());
        TsData data = this.getTsData();
        if (data != null) {
            builder.append(System.lineSeparator());
            builder.append(data.toString());
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Ts && this.equals((Ts)obj);
    }

    public int hashCode() {
        return this.getMoniker().hashCode();
    }

    private boolean equals(Ts other) {
        return other == null ? false : this.getMoniker().equals((Object)other.getMoniker());
    }

    public Ts rename(String newName) {
        return new Proxy(newName, this.getMaster());
    }

    public TsPeriodSelector getSelector(DataFeature feature) {
        TsPeriodSelector sel = new TsPeriodSelector();
        switch (feature.ordinal()) {
            case 0: {
                Day d0 = this.search(BEG);
                if (d0 != null) {
                    d0 = d0.minus(1);
                    sel.to(d0);
                    break;
                }
                sel.none();
                break;
            }
            case 1: {
                Day d0 = this.search(BEG);
                Day d1 = this.search(END);
                if (d0 != null && d1 != null) {
                    sel.between(d0, d1);
                    break;
                }
                if (d0 != null) {
                    sel.from(d0);
                    break;
                }
                if (d1 == null) break;
                sel.to(d1);
                break;
            }
            case 2: {
                Day d1 = this.search(END);
                if (d1 != null) {
                    d1 = d1.plus(1);
                    sel.from(d1);
                    break;
                }
                sel.none();
                break;
            }
            case 3: {
                Day d1 = this.search(CONFIDENTIAL);
                if (d1 == null) break;
                d1 = d1.minus(1);
                sel.to(d1);
                break;
            }
            case 4: {
                Day d1 = this.search(CONFIDENTIAL);
                if (d1 == null) break;
                sel.from(d1);
            }
        }
        return sel;
    }

    private Day search(String info) {
        MetaData md = this.getMetaData();
        if (md == null) {
            return null;
        }
        String d = md.get((Object)info);
        if (d == null) {
            return null;
        }
        try {
            return Day.fromString((String)d);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public boolean isFeature(DataFeature feature) {
        switch (feature.ordinal()) {
            case 0: {
                return this.search(BEG) != null;
            }
            case 2: {
                return this.search(END) != null;
            }
            case 3: 
            case 4: {
                return this.search(CONFIDENTIAL) != null;
            }
        }
        return true;
    }

    @Internal
    static final class Proxy
    extends Ts {
        private final Master master;

        private Proxy(String name, Master master) {
            super(name);
            this.master = master;
        }

        @Override
        public Ts freeze() {
            if (this.master.isFrozen()) {
                return this;
            }
            Ts frozen = this.master.freeze();
            return new Proxy(this.getName() + " [frozen]", frozen.getMaster());
        }

        @Override
        public TsInformationType getInformationType() {
            return this.master.getInformationType();
        }

        @Override
        public TsStatus hasMetaData() {
            return this.master.hasMetaData();
        }

        @Override
        public boolean isFrozen() {
            return this.master.isFrozen();
        }

        @Override
        public boolean set(MetaData md) {
            return this.master.set(md);
        }

        @Override
        public boolean set(TsData data) {
            return this.master.set(data);
        }

        @Override
        public boolean set(TsData data, MetaData md) {
            return this.master.set(data, md);
        }

        @Override
        public Ts unfreeze() {
            return this.master.unfreeze();
        }

        public MetaData getMetaData() {
            return this.master.getMetaData();
        }

        @Override
        public boolean load(TsInformationType type) {
            return this.master.load(type);
        }

        @Override
        Master getMaster() {
            return this.master;
        }

        @Override
        public TsStatus hasData() {
            return this.master.hasData();
        }

        @Override
        public TsData getTsData() {
            return this.master.getTsData();
        }

        @Override
        public boolean query(TsInformationType type) {
            return this.master.query(type);
        }

        @Override
        public boolean reload(TsInformationType type) {
            return this.master.reload(type);
        }

        @Override
        public TsMoniker getMoniker() {
            return this.master.getMoniker();
        }

        @Override
        public String getInvalidDataCause() {
            return this.master.getInvalidDataCause();
        }

        @Override
        public void setInvalidDataCause(String message) {
            this.master.setInvalidDataCause(message);
        }

        @Override
        public TsInformation toInfo(TsInformationType type) {
            TsInformation result = this.master.toInfo(type);
            result.name = this.getName();
            return result;
        }
    }

    @Internal
    static final class Master
    extends Ts {
        private final FactoryCallback factory;
        private final TsMoniker m_moniker;
        private MetaData m_metadata;
        private TsData m_data;
        private volatile TsInformationType m_info = TsInformationType.None;
        private String m_invalidDataMessage;

        @Deprecated
        @Internal
        Master(String name) {
            this(TsFactory.instance.getTsCallback(), name);
        }

        @Deprecated
        @Internal
        Master(String name, TsMoniker moniker) {
            this(TsFactory.instance.getTsCallback(), name, moniker);
        }

        @Internal
        Master(String name, TsMoniker moniker, MetaData md, TsData d) {
            this(TsFactory.instance.getTsCallback(), name, moniker, md, d);
        }

        @Deprecated
        @Internal
        Master(FactoryCallback factory, String name) {
            super(name);
            this.factory = factory;
            this.m_moniker = TsMoniker.createAnonymousMoniker();
            this.m_info = TsInformationType.UserDefined;
        }

        @Internal
        Master(FactoryCallback factory, String name, TsMoniker moniker) {
            super(name);
            this.factory = factory;
            this.m_moniker = moniker;
            if (moniker.getId() == null) {
                this.m_info = TsInformationType.UserDefined;
            }
        }

        @Internal
        Master(FactoryCallback factory, String name, TsMoniker moniker, MetaData md, TsData d) {
            super(name);
            this.factory = factory;
            this.m_moniker = moniker;
            this.m_metadata = md;
            this.m_data = d;
            if (md != null || d != null) {
                this.m_info = TsInformationType.UserDefined;
            }
        }

        @Override
        public TsMoniker getMoniker() {
            return this.m_moniker;
        }

        @Override
        public String getName() {
            if (this.isFrozen()) {
                return this.getRawName() + " [frozen]";
            }
            return this.getRawName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Ts freeze() {
            MetaData copyOfMeta;
            TsData copyOfData;
            if (this.isFrozen()) {
                return this;
            }
            TsMoniker tsMoniker = this.m_moniker;
            synchronized (tsMoniker) {
                this.load(TsInformationType.All);
                copyOfData = this.m_data != null ? this.m_data.clone() : null;
                copyOfMeta = this.m_metadata != null ? this.m_metadata.clone() : new MetaData();
            }
            Master.putFreezeMeta(copyOfMeta, this.m_moniker);
            return this.factory.createTs(this.getRawName(), copyOfMeta, copyOfData);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TsInformationType getInformationType() {
            TsMoniker tsMoniker = this.m_moniker;
            synchronized (tsMoniker) {
                return this.m_info;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MetaData getMetaData() {
            TsMoniker tsMoniker = this.m_moniker;
            synchronized (tsMoniker) {
                return this.m_metadata;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TsData getTsData() {
            TsMoniker tsMoniker = this.m_moniker;
            synchronized (tsMoniker) {
                return this.m_data;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TsStatus hasData() {
            TsMoniker tsMoniker = this.m_moniker;
            synchronized (tsMoniker) {
                if (this.m_info == TsInformationType.All || this.m_info == TsInformationType.Data || this.m_info == TsInformationType.UserDefined) {
                    return this.m_data == null ? TsStatus.Invalid : TsStatus.Valid;
                }
                return TsStatus.Undefined;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TsStatus hasMetaData() {
            TsMoniker tsMoniker = this.m_moniker;
            synchronized (tsMoniker) {
                if (this.m_info == TsInformationType.All || this.m_info == TsInformationType.MetaData || this.m_info == TsInformationType.UserDefined) {
                    return this.m_metadata == null ? TsStatus.Invalid : TsStatus.Valid;
                }
                return TsStatus.Undefined;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFrozen() {
            if (this.m_moniker.getSource() != null) {
                return false;
            }
            TsMoniker tsMoniker = this.m_moniker;
            synchronized (tsMoniker) {
                return Master.containsFreezeMeta(this.m_metadata);
            }
        }

        @Override
        public boolean load(TsInformationType type) {
            if (this.m_info.encompass(type)) {
                return true;
            }
            return this.factory.load(this, type);
        }

        @Override
        public boolean query(TsInformationType type) {
            if (this.m_info.encompass(type)) {
                return true;
            }
            return this.factory.query(this, type);
        }

        @Override
        public boolean reload(TsInformationType type) {
            return this.factory.load(this, type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean set(MetaData md) {
            TsMoniker tsMoniker = this.m_moniker;
            synchronized (tsMoniker) {
                if (this.m_info != TsInformationType.UserDefined) {
                    return false;
                }
                this.m_metadata = md;
            }
            this.factory.notify(this, TsInformationType.MetaData, this);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean set(TsData data) {
            TsMoniker tsMoniker = this.m_moniker;
            synchronized (tsMoniker) {
                if (this.m_info != TsInformationType.UserDefined) {
                    return false;
                }
                this.m_data = data;
            }
            this.factory.notify(this, TsInformationType.Data, this);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean set(TsData data, MetaData md) {
            TsMoniker tsMoniker = this.m_moniker;
            synchronized (tsMoniker) {
                if (this.m_info != TsInformationType.UserDefined) {
                    return false;
                }
                this.m_data = data;
                this.m_metadata = md;
            }
            this.factory.notify(this, TsInformationType.All, this);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Ts unfreeze() {
            TsMoniker origin;
            if (this.m_moniker.getSource() != null || this.m_moniker.getId() != null) {
                return this;
            }
            TsData copyOfData = null;
            TsMoniker tsMoniker = this.m_moniker;
            synchronized (tsMoniker) {
                origin = Master.getFreezeMeta(this.m_metadata);
                if (origin != null && TsMoniker.Type.DYNAMIC.equals((Object)origin.getType())) {
                    copyOfData = this.m_data == null ? null : this.m_data.clone();
                }
            }
            if (origin == null) {
                return this;
            }
            if (TsMoniker.Type.DYNAMIC.equals((Object)origin.getType())) {
                return this.factory.createTs(this.getRawName(), null, copyOfData);
            }
            return this.factory.createTs(this.getRawName(), origin, TsInformationType.None);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update(TsInformation info) {
            TsMoniker tsMoniker = this.m_moniker;
            synchronized (tsMoniker) {
                if (info.hasData()) {
                    this.m_data = info.data;
                }
                if (info.hasMetaData()) {
                    this.m_metadata = info.metaData;
                }
                this.m_info = this.m_info.union(info.type);
                this.m_invalidDataMessage = info.invalidDataCause;
            }
        }

        @Override
        Master getMaster() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setInvalidDataCause(String message) {
            TsMoniker tsMoniker = this.m_moniker;
            synchronized (tsMoniker) {
                this.m_invalidDataMessage = message;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getInvalidDataCause() {
            TsMoniker tsMoniker = this.m_moniker;
            synchronized (tsMoniker) {
                return this.m_invalidDataMessage;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TsInformation toInfo(TsInformationType type) {
            TsInformation result = new TsInformation(this.getRawName(), this.m_moniker, type);
            this.load(type);
            TsMoniker tsMoniker = this.m_moniker;
            synchronized (tsMoniker) {
                if (result.hasData()) {
                    result.data = this.m_data;
                }
                if (result.hasMetaData()) {
                    result.metaData = this.m_metadata;
                }
                result.invalidDataCause = this.m_invalidDataMessage;
            }
            return result;
        }

        private static void putFreezeMeta(@NonNull MetaData md, @NonNull TsMoniker origin) {
            if (origin.getSource() != null) {
                md.put("@source", origin.getSource());
            }
            if (origin.getId() != null) {
                md.put("@id", origin.getId());
            }
            md.put("@timestamp", new Date().toString());
        }

        private static boolean containsFreezeMeta(@Nullable MetaData md) {
            if (md == null) {
                return false;
            }
            if (md.containsKey((Object)"@source")) {
                return true;
            }
            return md.containsKey((Object)Ts.SOURCE_OLD);
        }

        private static @Nullable TsMoniker getFreezeMeta(@Nullable MetaData md) {
            if (md == null) {
                return null;
            }
            String source = md.get((Object)"@source");
            if (source == null) {
                source = md.get((Object)Ts.SOURCE_OLD);
            }
            if (Ts.DYNAMIC.equals(source)) {
                return TsMoniker.createDynamicMoniker();
            }
            String id = md.get((Object)"@id");
            if (id == null) {
                id = md.get((Object)Ts.ID_OLD);
            }
            if (source == null || id == null) {
                return null;
            }
            return TsMoniker.createProvidedMoniker(source, id);
        }
    }

    public static enum DataFeature {
        Backcasts,
        Actual,
        Forecasts,
        Public,
        Confidential;

    }

    @Internal
    static interface FactoryCallback {
        public boolean load(@NonNull Ts var1, @NonNull TsInformationType var2);

        public boolean query(@NonNull Ts var1, @NonNull TsInformationType var2);

        public void notify(Ts var1, TsInformationType var2, Object var3);

        public @NonNull Ts createTs(@Nullable String var1, @Nullable MetaData var2, @Nullable TsData var3);

        public @NonNull Ts createTs(@Nullable String var1, @NonNull TsMoniker var2, @NonNull TsInformationType var3);
    }
}

