/*
 * Decompiled with CFR 0.152.
 */
package ec.tss;

import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import ec.tss.ITsIdentified;
import ec.tss.Ts;
import ec.tss.TsCollectionInformation;
import ec.tss.TsFactory;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tss.TsStatus;
import ec.tss.tsproviders.utils.MultiLineNameUtil;
import ec.tstoolkit.IDocumented;
import ec.tstoolkit.MetaData;
import ec.tstoolkit.design.Internal;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TsCollection
implements ITsIdentified,
IDocumented,
Iterable<Ts> {
    private final FactoryCallback factory;
    private final TsMoniker m_moniker;
    private final String m_name;
    private MetaData m_metadata;
    private final List<Ts> m_ts;
    private volatile TsInformationType m_info;
    private volatile Set<TsMoniker> m_set;
    private String m_invalidDataCause;

    @Deprecated
    @Internal
    TsCollection(@Nullable String name) {
        this(TsFactory.instance.getTsCollectionCallback(), name);
    }

    @Deprecated
    @Internal
    TsCollection(@Nullable String name, @NonNull TsMoniker moniker) {
        this(TsFactory.instance.getTsCollectionCallback(), name, moniker);
    }

    @Deprecated
    @Internal
    TsCollection(@Nullable String name, @NonNull TsMoniker moniker, @Nullable MetaData md, @Nullable Iterable<Ts> ts) {
        this(TsFactory.instance.getTsCollectionCallback(), name, moniker, md, ts);
    }

    @Internal
    TsCollection(FactoryCallback factory, @Nullable String name) {
        this.factory = factory;
        this.m_name = Strings.nullToEmpty((String)name);
        this.m_moniker = TsMoniker.createAnonymousMoniker();
        this.m_metadata = null;
        this.m_ts = new ArrayList<Ts>();
        this.m_info = TsInformationType.UserDefined;
        this.m_set = null;
        this.m_invalidDataCause = null;
    }

    @Internal
    TsCollection(FactoryCallback factory, @Nullable String name, @NonNull TsMoniker moniker) {
        this.factory = factory;
        this.m_name = Strings.nullToEmpty((String)name);
        this.m_moniker = moniker;
        this.m_metadata = null;
        this.m_ts = new ArrayList<Ts>();
        this.m_info = this.m_moniker.getSource() == null ? TsInformationType.UserDefined : TsInformationType.None;
        this.m_set = null;
        this.m_invalidDataCause = null;
    }

    @Internal
    TsCollection(FactoryCallback factory, @Nullable String name, @NonNull TsMoniker moniker, @Nullable MetaData md, @Nullable Iterable<Ts> ts) {
        this.factory = factory;
        this.m_name = Strings.nullToEmpty((String)name);
        this.m_moniker = moniker;
        this.m_metadata = md;
        this.m_ts = ts != null ? Lists.newArrayList(ts) : new ArrayList();
        this.m_info = TsInformationType.UserDefined;
        this.m_set = null;
        this.m_invalidDataCause = null;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInvalidDataCause() {
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            return this.m_invalidDataCause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInvalidDataCause(String message) {
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            this.m_invalidDataCause = message;
        }
    }

    public boolean add(Ts ts) {
        if (this.quietAdd(ts)) {
            this.factory.notify(this, TsInformationType.Definition, this);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean quietAdd(Ts ts) {
        if (this.isLocked()) {
            return false;
        }
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            if (this.contains(ts)) {
                return false;
            }
            this.m_ts.add(ts);
            this.m_set = null;
        }
        return true;
    }

    public int append(Iterable<? extends Ts> list) {
        int n = this.quietAppend(list);
        if (n > 0) {
            this.factory.notify(this, TsInformationType.Definition, this);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int quietAppend(Iterable<? extends Ts> list) {
        if (this.isLocked()) {
            return 0;
        }
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            ArrayList<Ts> tmp = new ArrayList<Ts>();
            for (Ts ts : list) {
                if (this.contains(ts) || tmp.contains(ts)) continue;
                tmp.add(ts);
            }
            if (!tmp.isEmpty()) {
                this.m_ts.addAll(tmp);
                this.m_set = null;
                return tmp.size();
            }
            return 0;
        }
    }

    public int append(TsCollection c) {
        return this.append(c.m_ts);
    }

    public int quietAppend(TsCollection c) {
        return this.quietAppend(c.m_ts);
    }

    private void buildSet() {
        this.m_set = this.m_ts.stream().map(ITsIdentified::getMoniker).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TsCollection clean(boolean empty) {
        ArrayList<Ts> list;
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            list = new ArrayList<Ts>(this.m_ts.size());
            for (Ts s : this.m_ts) {
                if (s.hasData() == TsStatus.Valid) {
                    list.add(s);
                    continue;
                }
                if (s.hasData() != TsStatus.Undefined) continue;
                s.load(TsInformationType.Data);
                if (s.hasData() != TsStatus.Valid) continue;
                list.add(s);
            }
        }
        if (list.isEmpty() && !empty) {
            return null;
        }
        return this.factory.createTsCollection(this.m_name, TsMoniker.createAnonymousMoniker(), null, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TsCollection clean(double cntVal, boolean empty) {
        ArrayList<Ts> list;
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            list = new ArrayList<Ts>(this.m_ts.size());
            block3: for (Ts s : this.m_ts) {
                if (s.hasData() == TsStatus.Undefined) {
                    s.load(TsInformationType.Data);
                }
                if (s.hasData() != TsStatus.Valid) continue;
                TsData data = s.getTsData();
                for (int i = 0; i < data.getLength(); ++i) {
                    double d = data.get(i);
                    if (Double.isNaN(d) || d == cntVal) continue;
                    list.add(s);
                    continue block3;
                }
            }
        }
        if (list.isEmpty() && !empty) {
            return null;
        }
        return this.factory.createTsCollection(this.m_name, TsMoniker.createAnonymousMoniker(), null, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.isLocked()) {
            return;
        }
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            if (this.m_ts.isEmpty()) {
                return;
            }
            this.m_ts.clear();
            this.m_set = null;
        }
        this.factory.notify(this, TsInformationType.Definition, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Ts s) {
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            if (this.m_set == null) {
                this.buildSet();
            }
            return this.m_set.contains(s.getMoniker());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ts[] retain(Iterable<Ts> all) {
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            if (all == null) {
                return new Ts[0];
            }
            if (this.m_set == null) {
                this.buildSet();
            }
            return (Ts[])Streams.stream(all).filter(o -> this.m_set.contains(o.getMoniker())).toArray(Ts[]::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ts[] toArray() {
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            return this.m_ts.toArray(new Ts[this.m_ts.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Ts ts) {
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            for (int i = 0; i < this.m_ts.size(); ++i) {
                if (!ts.equals((Object)this.m_ts.get(i))) continue;
                return i;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ts get(int idx) {
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            return this.m_ts.get(idx);
        }
    }

    public List<TsData> getAllData() {
        Ts[] all = this.toArray();
        ArrayList<TsData> data = new ArrayList<TsData>();
        for (int i = 0; i < all.length; ++i) {
            if (all[i].hasData() == TsStatus.Undefined) {
                all[i].load(TsInformationType.Data);
            }
            if (all[i].hasData() != TsStatus.Valid) continue;
            data.add(all[i].getTsData());
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            return this.m_ts.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            return this.m_ts.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TsInformationType getInformationType() {
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            return this.m_info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaData getMetaData() {
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            return this.m_metadata;
        }
    }

    @Override
    public TsMoniker getMoniker() {
        return this.m_moniker;
    }

    public TsStatus hasMetaData() {
        if (this.m_info == TsInformationType.All || this.m_info == TsInformationType.MetaData || this.m_info == TsInformationType.UserDefined) {
            return this.m_metadata == null ? TsStatus.Invalid : TsStatus.Valid;
        }
        return TsStatus.Undefined;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(int pos, Ts ts) {
        if (this.isLocked()) {
            return false;
        }
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            if (this.contains(ts)) {
                return false;
            }
            this.m_ts.add(pos, ts);
            this.m_set = null;
        }
        this.factory.notify(this, TsInformationType.Definition, this);
        return true;
    }

    public boolean isLocked() {
        return this.m_moniker.getSource() != null;
    }

    @Override
    public Iterator<Ts> iterator() {
        return Iterators.forArray((Object[])this.toArray());
    }

    public @NonNull Stream<Ts> stream() {
        return Stream.of(this.toArray());
    }

    public boolean load(TsInformationType type) {
        if (this.m_info.encompass(type)) {
            return true;
        }
        if (this.m_moniker.isAnonymous()) {
            return this.m_ts.stream().map(o -> o.load(type)).reduce(Boolean.TRUE, (l, r) -> r != false && l != false);
        }
        return this.factory.load(this, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TsCollection makeCopy() {
        TsCollection coll = this.factory.createTsCollection(this.m_name);
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            if (this.m_metadata != null) {
                coll.m_metadata = this.m_metadata.clone();
            }
            coll.m_ts.addAll(this.m_ts);
        }
        return coll;
    }

    public boolean query(TsInformationType type) {
        if (this.m_info.encompass(type)) {
            return true;
        }
        return this.factory.query(this, type);
    }

    public boolean reload(TsInformationType type) {
        return this.factory.load(this, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remove(Iterable<Ts> c) {
        if (this.isLocked()) {
            return 0;
        }
        int rslt = 0;
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            ArrayList<Ts> tmp = new ArrayList<Ts>();
            for (Ts s : c) {
                if (!this.contains(s) || tmp.contains(s)) continue;
                tmp.add(s);
            }
            if (!tmp.isEmpty()) {
                this.m_ts.removeAll(tmp);
                this.m_set = null;
                rslt = tmp.size();
            }
        }
        if (rslt > 0) {
            this.factory.notify(this, TsInformationType.Definition, this);
        }
        return rslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Ts s) {
        if (this.isLocked()) {
            return false;
        }
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            if (!this.contains(s)) {
                return false;
            }
            this.m_ts.remove(s);
            this.m_set = null;
        }
        this.factory.notify(this, TsInformationType.Definition, this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAt(int pos) {
        if (this.isLocked()) {
            return;
        }
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            this.m_ts.remove(pos);
            this.m_set = null;
        }
        this.factory.notify(this, TsInformationType.Definition, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRange(int start, int n) {
        if (this.isLocked()) {
            return;
        }
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            for (int pos = start + n - 1; pos >= start; --pos) {
                this.m_ts.remove(pos);
            }
            this.m_set = null;
        }
        this.factory.notify(this, TsInformationType.Definition, this);
    }

    public boolean replace(Iterable<Ts> c) {
        if (this.quietReplace(c)) {
            this.factory.notify(this, TsInformationType.Definition, this);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean quietReplace(Iterable<Ts> c) {
        if (this.isLocked()) {
            return false;
        }
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            this.m_ts.clear();
            for (Ts s : c) {
                this.m_ts.add(s);
            }
            this.m_set = null;
        }
        return true;
    }

    public boolean replace(Ts s) {
        if (this.quietReplace(s)) {
            this.factory.notify(this, TsInformationType.Definition, this);
            return true;
        }
        return false;
    }

    public boolean replace(Ts ... s) {
        if (this.quietReplace(s)) {
            this.factory.notify(this, TsInformationType.Definition, this);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean quietReplace(Ts ... c) {
        if (this.isLocked()) {
            return false;
        }
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            this.m_ts.clear();
            if (c != null) {
                this.m_ts.addAll(Arrays.asList(c));
            }
            this.m_set = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean quietReplace(Ts s) {
        if (this.isLocked()) {
            return false;
        }
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            if (this.m_ts.size() == 1 && this.m_ts.get(0).getMoniker().equals((Object)s.getMoniker())) {
                return true;
            }
            this.m_ts.clear();
            this.m_ts.add(s);
            this.m_set = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ts search(String name) {
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            for (Ts s : this.m_ts) {
                if (!s.getName().equals(name)) continue;
                return s;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ts search(TsMoniker moniker) {
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            for (Ts s : this.m_ts) {
                if (!s.getMoniker().equals((Object)moniker)) continue;
                return s;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(Ts s, String newname) {
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            int pos = this.m_ts.indexOf(s);
            if (pos < 0) {
                return false;
            }
            this.m_ts.set(pos, this.m_ts.get(pos).rename(newname));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(MetaData md) {
        if (this.m_info != TsInformationType.UserDefined) {
            return false;
        }
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            this.m_metadata = md;
        }
        this.factory.notify(this, TsInformationType.MetaData, this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Ts> update(TsCollectionInformation info) {
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            List<Ts> updated;
            if (info.hasMetaData()) {
                this.m_metadata = info.metaData;
            }
            if (info.hasDefinition()) {
                this.m_ts.clear();
                if (!info.items.isEmpty()) {
                    updated = new ArrayList(info.items.size());
                    for (TsInformation sinfo : info.items) {
                        Ts s = this.factory.getTs(sinfo.moniker);
                        if (s != null) {
                            s.getMaster().update(sinfo);
                            updated.add(s);
                        } else {
                            s = this.factory.createTs(sinfo);
                        }
                        this.m_ts.add(s);
                    }
                } else {
                    updated = Collections.emptyList();
                }
            } else {
                updated = Collections.emptyList();
            }
            this.m_info = this.m_info.union(info.type);
            this.m_invalidDataCause = info.invalidDataCause;
            return updated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            String[] headers = new String[this.m_ts.size()];
            List<TsData> all = this.getAllData();
            for (int i = 0; i < headers.length; ++i) {
                headers[i] = MultiLineNameUtil.last(this.m_ts.get(i).getName());
            }
            TsDataTable table = new TsDataTable();
            table.add(all);
            return table.toString(headers);
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TsCollection && this.equals((TsCollection)obj);
    }

    public int hashCode() {
        return this.getMoniker().hashCode();
    }

    private boolean equals(TsCollection other) {
        return other == null ? false : this.getMoniker().equals((Object)other.getMoniker());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull TsCollectionInformation toInfo(@NonNull TsInformationType type) {
        TsCollectionInformation result = new TsCollectionInformation(this.m_moniker, type);
        result.type = type;
        result.name = this.m_name;
        this.load(type);
        TsMoniker tsMoniker = this.m_moniker;
        synchronized (tsMoniker) {
            this.stream().map(o -> o.toInfo(type)).forEach(result.items::add);
            result.metaData = this.m_metadata;
            result.invalidDataCause = this.m_invalidDataCause;
        }
        return result;
    }

    @Internal
    static interface FactoryCallback {
        public boolean load(@NonNull TsCollection var1, @NonNull TsInformationType var2);

        public boolean query(@NonNull TsCollection var1, @NonNull TsInformationType var2);

        public void notify(TsCollection var1, TsInformationType var2, Object var3);

        public @Nullable Ts getTs(@Nullable TsMoniker var1);

        public Ts createTs(TsInformation var1);

        public @NonNull TsCollection createTsCollection(@Nullable String var1, @Nullable TsMoniker var2, @Nullable MetaData var3, @Nullable Iterable<Ts> var4);

        public @NonNull TsCollection createTsCollection(@Nullable String var1);
    }
}

