/*
 * Decompiled with CFR 0.152.
 */
package ec.tss;

import ec.tss.ITsProvider;
import ec.tss.Ts;
import ec.tss.TsAsyncMode;
import ec.tss.TsCollection;
import ec.tss.TsCollectionInformation;
import ec.tss.TsEvent;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.HasDataSourceList;
import ec.tss.tsproviders.IDataSourceListener;
import ec.tss.tsproviders.IDataSourceProvider;
import ec.tstoolkit.MetaData;
import ec.tstoolkit.design.InterfaceLoader;
import ec.tstoolkit.design.Internal;
import ec.tstoolkit.design.Singleton;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class TsFactory {
    public static final TsFactory instance;
    private final HashMap<String, ITsProvider> m_providers = new HashMap();
    private final HashMap<TsMoniker, WeakReference<TsCollection>> m_collections = new HashMap();
    private final HashMap<TsMoniker, WeakReference<Ts.Master>> m_ts = new HashMap();
    private boolean m_close;
    private final long m_threadID;
    private boolean m_useSynchronousNotifications = true;
    NotificationsQueue notifications = new NotificationsQueue();
    TsFactoryCleaner cleaner = new TsFactoryCleaner();
    private final ReloadListener reloadListener = new ReloadListener();
    private final Ts.FactoryCallback tsCallback = new TsCallback();
    private final TsCollection.FactoryCallback tsCollectionCallback = new TsCollectionCallback();

    private TsFactory() {
        this.m_threadID = Thread.currentThread().getId();
    }

    public final boolean add(ITsProvider provider) {
        if (this.m_providers.containsKey(provider.getSource())) {
            return false;
        }
        this.m_providers.put(provider.getSource(), provider);
        if (provider instanceof HasDataSourceList) {
            ((HasDataSourceList)((Object)provider)).addDataSourceListener(this.reloadListener);
        }
        return true;
    }

    public final boolean addAll(Iterable<? extends ITsProvider> list) {
        boolean result = false;
        for (ITsProvider iTsProvider : list) {
            result |= this.add(iTsProvider);
        }
        return result;
    }

    private void addEvent(TsEvent ev) {
        if (this.m_useSynchronousNotifications && this.m_threadID == Thread.currentThread().getId()) {
            this.notifications.dispatch(ev);
        } else {
            this.notifications.add(ev);
        }
    }

    public void addObserver(Observer obs) {
        this.notifications.addObserver(obs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanTS() {
        HashMap<TsMoniker, WeakReference<Ts.Master>> hashMap = this.m_ts;
        synchronized (hashMap) {
            HashMap<TsMoniker, WeakReference<Ts.Master>> tmp = new HashMap<TsMoniker, WeakReference<Ts.Master>>();
            int n = 0;
            for (Map.Entry<TsMoniker, WeakReference<Ts.Master>> r : this.m_ts.entrySet()) {
                if (r.getValue().get() != null) {
                    tmp.put(r.getKey(), r.getValue());
                    continue;
                }
                ++n;
            }
            this.m_ts.clear();
            this.m_ts.putAll(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanTSCollection() {
        HashMap<TsMoniker, WeakReference<TsCollection>> hashMap = this.m_collections;
        synchronized (hashMap) {
            HashMap tmp = new HashMap();
            this.m_collections.forEach((k, v) -> {
                if (v.get() != null) {
                    tmp.put(k, v);
                }
            });
            this.m_collections.clear();
            this.m_collections.putAll(tmp);
        }
    }

    public void clear() {
        this.m_providers.values().forEach(ITsProvider::dispose);
        this.m_providers.clear();
    }

    public void clearCache() {
        this.m_providers.forEach((k, v) -> v.clearCache());
        this.cleanTSCollection();
        this.cleanTS();
    }

    public @NonNull Ts createTs() {
        return this.createTs("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull Ts createTs(@Nullable String name) {
        HashMap<TsMoniker, WeakReference<Ts.Master>> hashMap = this.m_ts;
        synchronized (hashMap) {
            Ts.Master ts = new Ts.Master(this.tsCallback, name);
            this.m_ts.put(ts.getMoniker(), new WeakReference<Ts.Master>(ts));
            return ts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Ts createTs(TsInformation info) {
        HashMap<TsMoniker, WeakReference<Ts.Master>> hashMap = this.m_ts;
        synchronized (hashMap) {
            Ts.Master ts = null;
            WeakReference<Ts.Master> wref = this.m_ts.get(info.moniker);
            if (wref != null) {
                ts = (Ts.Master)wref.get();
            }
            if (ts == null) {
                ts = new Ts.Master(this.tsCallback, info.name, info.moniker);
            }
            ts.update(info);
            this.m_ts.put(ts.getMoniker(), new WeakReference<Ts.Master>(ts));
            return ts;
        }
    }

    public @NonNull Ts createTs(@Nullable String name, @Nullable MetaData md, @Nullable TsData d) {
        return this.createTs(name, new TsMoniker(), md, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull Ts createTs(@Nullable String name, @Nullable TsMoniker moniker, @Nullable MetaData md, @Nullable TsData d) {
        HashMap<TsMoniker, WeakReference<Ts.Master>> hashMap = this.m_ts;
        synchronized (hashMap) {
            WeakReference<Ts.Master> wref = null;
            if (moniker != null) {
                wref = this.m_ts.get(moniker);
            }
            if (wref != null) {
                Ts.Master ts = (Ts.Master)wref.get();
                if (ts != null) {
                    return ts.rename(name);
                }
                ts = new Ts.Master(this.tsCallback, name, moniker, md, d);
                this.m_ts.put(moniker, new WeakReference<Ts.Master>(ts));
                return ts;
            }
            if (moniker == null) {
                moniker = new TsMoniker();
            }
            Ts.Master ts = new Ts.Master(this.tsCallback, name, moniker, md, d);
            this.m_ts.put(ts.getMoniker(), new WeakReference<Ts.Master>(ts));
            return ts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull Ts createTs(@Nullable String name, @NonNull TsMoniker moniker, @NonNull TsInformationType type) {
        HashMap<TsMoniker, WeakReference<Ts.Master>> hashMap = this.m_ts;
        synchronized (hashMap) {
            Ts.Master result = (Ts.Master)this.getTs(moniker);
            if (result == null) {
                if (type != TsInformationType.None) {
                    TsInformation info = new TsInformation(name, moniker, type);
                    this.fill(info);
                    result = new Ts.Master(this.tsCallback, name != null ? name : info.name, moniker);
                    result.update(info);
                } else {
                    result = new Ts.Master(this.tsCallback, name, moniker);
                }
                this.m_ts.put(moniker, new WeakReference<Ts.Master>(result));
            } else {
                result.load(type);
            }
            return result;
        }
    }

    private boolean fill(TsInformation info) {
        ITsProvider provider = this.getProvider(info.moniker.getSource());
        if (provider == null) {
            info.invalidDataCause = "Missing provider";
            return false;
        }
        if (!provider.get(info)) {
            if (info.invalidDataCause == null) {
                info.invalidDataCause = "Unknown error";
            }
            return false;
        }
        return true;
    }

    public @NonNull TsCollection createTsCollection() {
        return this.createTsCollection("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull TsCollection createTsCollection(@Nullable String name) {
        HashMap<TsMoniker, WeakReference<TsCollection>> hashMap = this.m_collections;
        synchronized (hashMap) {
            TsCollection coll = new TsCollection(this.tsCollectionCallback, name);
            this.m_collections.put(coll.getMoniker(), new WeakReference<TsCollection>(coll));
            return coll;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull TsCollection createTsCollection(@Nullable String name, @Nullable TsMoniker moniker, @Nullable MetaData md, @Nullable Iterable<Ts> ts) {
        HashMap<TsMoniker, WeakReference<TsCollection>> hashMap = this.m_collections;
        synchronized (hashMap) {
            if (moniker == null) {
                TsCollection c = new TsCollection(this.tsCollectionCallback, name, new TsMoniker(), md, ts);
                this.m_collections.put(c.getMoniker(), new WeakReference<TsCollection>(c));
                return c;
            }
            WeakReference<TsCollection> wref = this.m_collections.get(moniker);
            if (wref != null) {
                TsCollection c = (TsCollection)wref.get();
                if (c != null) {
                    return c;
                }
                c = new TsCollection(this.tsCollectionCallback, name, moniker, md, ts);
                this.m_collections.put(c.getMoniker(), new WeakReference<TsCollection>(c));
                return c;
            }
            TsCollection c = new TsCollection(this.tsCollectionCallback, name, moniker, md, ts);
            this.m_collections.put(c.getMoniker(), new WeakReference<TsCollection>(c));
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull TsCollection createTsCollection(@Nullable String name, @NonNull TsMoniker moniker, @NonNull TsInformationType type) {
        HashMap<TsMoniker, WeakReference<TsCollection>> hashMap = this.m_collections;
        synchronized (hashMap) {
            TsCollection result = this.getTsCollection(moniker);
            if (result == null) {
                result = new TsCollection(this.tsCollectionCallback, name, moniker);
                if (type != TsInformationType.None) {
                    TsCollectionInformation info = new TsCollectionInformation(moniker, type);
                    this.fill(info);
                    List<Ts> updated = result.update(info);
                    for (Ts s : updated) {
                        this.notify(s, type, (Object)result);
                    }
                }
                this.m_collections.put(moniker, new WeakReference<TsCollection>(result));
            } else {
                result.load(type);
            }
            return result;
        }
    }

    private boolean fill(TsCollectionInformation info) {
        ITsProvider provider = this.getProvider(info.moniker.getSource());
        if (provider == null) {
            info.invalidDataCause = "Missing provider";
            return false;
        }
        if (!provider.get(info)) {
            if (info.invalidDataCause == null) {
                info.invalidDataCause = "Unknown error";
            }
            return false;
        }
        return true;
    }

    public void deleteObserver(Observer obs) {
        this.notifications.deleteObserver(obs);
    }

    public void dispose() {
        this.m_close = true;
        this.m_providers.values().forEach(ITsProvider::dispose);
        this.cleaner.interrupt();
        this.notifications.notificationThread.interrupt();
    }

    public @Nullable ITsProvider getProvider(@Nullable String source) {
        if (source == null) {
            return null;
        }
        return this.m_providers.get(source);
    }

    public @NonNull String[] getProviders() {
        return (String[])this.m_providers.keySet().stream().toArray(String[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Ts getTs(@Nullable TsMoniker moniker) {
        HashMap<TsMoniker, WeakReference<Ts.Master>> hashMap = this.m_ts;
        synchronized (hashMap) {
            WeakReference<Ts.Master> wref = this.m_ts.get(moniker);
            if (wref != null) {
                Ts ts = (Ts)wref.get();
                if (ts == null) {
                    this.m_ts.remove(moniker);
                }
                return ts;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable TsCollection getTsCollection(@Nullable TsMoniker moniker) {
        HashMap<TsMoniker, WeakReference<TsCollection>> hashMap = this.m_collections;
        synchronized (hashMap) {
            WeakReference<TsCollection> wref = this.m_collections.get(moniker);
            if (wref != null) {
                TsCollection collection = (TsCollection)wref.get();
                if (collection == null) {
                    this.m_collections.remove(moniker);
                }
                return collection;
            }
            return null;
        }
    }

    public boolean isClosing() {
        return this.m_close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTsAlive(@Nullable TsMoniker moniker) {
        if (this.m_close) {
            return false;
        }
        HashMap<TsMoniker, WeakReference<Ts.Master>> hashMap = this.m_ts;
        synchronized (hashMap) {
            WeakReference<Ts.Master> wref = this.m_ts.get(moniker);
            if (wref == null) {
                return false;
            }
            return wref.get() != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTsCollectionAlive(@Nullable TsMoniker moniker) {
        if (this.m_close) {
            return false;
        }
        HashMap<TsMoniker, WeakReference<TsCollection>> hashMap = this.m_collections;
        synchronized (hashMap) {
            WeakReference<TsCollection> wref = this.m_collections.get(moniker);
            if (wref == null) {
                return false;
            }
            return wref.get() != null;
        }
    }

    public boolean isUsingSynchronousNotifications() {
        return this.m_useSynchronousNotifications;
    }

    private boolean doLoad(@NonNull Ts.Master ts, @NonNull TsInformationType type) {
        if (ts.getMoniker().isAnonymous()) {
            return true;
        }
        TsInformation info = new TsInformation(ts.getName(), ts.getMoniker(), type);
        boolean result = this.fill(info);
        ts.update(info);
        this.notify(ts, info.type, (Object)this);
        return result;
    }

    private boolean doLoad(@NonNull TsCollection c, @NonNull TsInformationType type) {
        if (c.getMoniker().isAnonymous()) {
            return true;
        }
        TsCollectionInformation info = new TsCollectionInformation(c.getMoniker(), type);
        boolean result = this.fill(info);
        List<Ts> updated = c.update(info);
        this.notify(c, info.type, (Object)this);
        updated.forEach(s -> this.notify((Ts)s, info.type, (Object)c));
        return result;
    }

    public boolean load(@NonNull Ts ts, @NonNull TsInformationType type) {
        return this.doLoad(ts.getMaster(), type);
    }

    public boolean load(Ts[] list, TsInformationType type) {
        boolean ok = false;
        for (Ts s : list) {
            if (!this.load(s, type)) continue;
            ok = true;
        }
        return ok;
    }

    public boolean load(@NonNull TsCollection c, @NonNull TsInformationType type) {
        ITsProvider provider = this.getProvider(c.getMoniker().getSource());
        if (provider == null) {
            return this.load(c.toArray(), type);
        }
        return this.doLoad(c, type);
    }

    public void notify(Ts s, TsInformationType type, Object sender) {
        this.addEvent(new TsEvent(s, type, sender));
    }

    public void notify(TsCollection s, TsInformationType type, Object sender) {
        this.addEvent(new TsEvent(s, type, sender));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean query(@NonNull Ts s, @NonNull TsInformationType type) {
        if (type == TsInformationType.None) {
            return true;
        }
        ITsProvider provider = this.getProvider(s.getMoniker().getSource());
        if (provider == null) {
            return false;
        }
        HashMap<TsMoniker, WeakReference<Ts.Master>> hashMap = this.m_ts;
        synchronized (hashMap) {
            return provider.getAsyncMode() == TsAsyncMode.None ? this.doLoad(s.getMaster(), type) : provider.queryTs(s.getMoniker(), type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean query(@NonNull TsCollection c, @NonNull TsInformationType type) {
        if (type == TsInformationType.None) {
            return true;
        }
        ITsProvider provider = this.getProvider(c.getMoniker().getSource());
        if (provider == null) {
            Ts[] s = c.toArray();
            for (int i = 0; i < s.length; ++i) {
                this.query(s[i], type);
            }
            return true;
        }
        HashMap<TsMoniker, WeakReference<TsCollection>> hashMap = this.m_collections;
        synchronized (hashMap) {
            return provider.getAsyncMode() == TsAsyncMode.None ? this.doLoad(c, type) : provider.queryTsCollection(c.getMoniker(), type);
        }
    }

    public ITsProvider register(String module, String providerclass) {
        try {
            ITsProvider iprovider = (ITsProvider)InterfaceLoader.create((String)module, Class.forName("ec.tstoolkit.timeseries.ts.ITSProvider"), (String)providerclass);
            if (iprovider == null) {
                return null;
            }
            String name = iprovider.getSource();
            this.m_providers.put(name, iprovider);
            return iprovider;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public void remove(String name) {
        if (this.m_providers.containsKey(name)) {
            ITsProvider provider = this.m_providers.get(name);
            if (provider instanceof HasDataSourceList) {
                ((HasDataSourceList)((Object)provider)).removeDataSourceListener(this.reloadListener);
            }
            provider.dispose();
            this.m_providers.remove(name);
        }
    }

    public @Nullable ITsProvider search(String classname) {
        for (ITsProvider provider : this.m_providers.values()) {
            if (!provider.getClass().getName().equals(classname)) continue;
            return provider;
        }
        return null;
    }

    private void start() {
        this.cleaner.start();
        this.notifications.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(@NonNull TsCollectionInformation info) {
        HashMap<TsMoniker, WeakReference<TsCollection>> hashMap = this.m_collections;
        synchronized (hashMap) {
            TsCollection c = this.getTsCollection(info.moniker);
            if (c != null) {
                List<Ts> updated = c.update(info);
                this.notify(c, info.type, null);
                updated.forEach(s -> this.notify((Ts)s, info.type, (Object)c));
            } else {
                info.items.forEach(sinfo -> this.update((TsInformation)sinfo));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(@NonNull TsInformation info) {
        HashMap<TsMoniker, WeakReference<Ts.Master>> hashMap = this.m_ts;
        synchronized (hashMap) {
            Ts.Master s = (Ts.Master)this.getTs(info.moniker);
            if (s == null) {
                return;
            }
            s.update(info);
            this.notify(s, info.type, null);
        }
    }

    public void useSynchronousNotifications(boolean value) {
        this.m_useSynchronousNotifications = value;
    }

    public static @NonNull Collector<Ts, ?, TsCollection> toTsCollection() {
        return Collector.of(ArrayList::new, List::add, (l, r) -> {
            l.addAll(r);
            return l;
        }, o -> instance.createTsCollection(null, null, null, (Iterable<Ts>)o), new Collector.Characteristics[0]);
    }

    @Internal
    Ts.FactoryCallback getTsCallback() {
        return this.tsCallback;
    }

    @Internal
    TsCollection.FactoryCallback getTsCollectionCallback() {
        return this.tsCollectionCallback;
    }

    static {
        TsFactory cur = new TsFactory();
        cur.start();
        instance = cur;
    }

    class NotificationsQueue
    extends Observable
    implements Runnable {
        final Thread notificationThread;
        private final ArrayDeque<TsEvent> m_events = new ArrayDeque();

        NotificationsQueue() {
            this.notificationThread = new Thread(this);
            this.notificationThread.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(TsEvent event) {
            ArrayDeque<TsEvent> arrayDeque = this.m_events;
            synchronized (arrayDeque) {
                boolean empty = this.m_events.isEmpty();
                this.m_events.add(event);
                if (empty) {
                    LockSupport.unpark(this.notificationThread);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch(TsEvent event) {
            ArrayDeque<TsEvent> arrayDeque = this.m_events;
            synchronized (arrayDeque) {
                this.setChanged();
                try {
                    this.notifyObservers(event);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TsEvent nextEvent() {
            ArrayDeque<TsEvent> arrayDeque = this.m_events;
            synchronized (arrayDeque) {
                if (this.m_events.isEmpty()) {
                    return null;
                }
                return this.m_events.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void popEvent() {
            ArrayDeque<TsEvent> arrayDeque = this.m_events;
            synchronized (arrayDeque) {
                this.m_events.pop();
            }
        }

        @Override
        public void run() {
            while (!TsFactory.this.isClosing()) {
                TsEvent nev = this.nextEvent();
                if (nev == null) {
                    LockSupport.park();
                    continue;
                }
                this.dispatch(nev);
                this.popEvent();
            }
            return;
        }

        void start() {
            this.notificationThread.start();
        }
    }

    class TsFactoryCleaner
    extends Thread {
        public TsFactoryCleaner() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!TsFactory.this.isClosing()) {
                TsFactory.this.cleanTS();
                TsFactory.this.cleanTSCollection();
                LockSupport.parkNanos(10000000000L);
            }
            return;
        }
    }

    private final class ReloadListener
    implements IDataSourceListener {
        private ReloadListener() {
        }

        @Override
        public void changed(DataSource dataSource) {
            ITsProvider p = TsFactory.this.getProvider(dataSource.getProviderName());
            if (p instanceof IDataSourceProvider) {
                IDataSourceProvider o = (IDataSourceProvider)p;
                this.reloadTSCollection(o, dataSource);
                this.reloadTS(o, dataSource);
            }
        }

        private void reloadTSCollection(IDataSourceProvider p, DataSource dataSource) {
            Stream.of(this.lookupTsCollection(p, dataSource)).forEach(this.getTsCollectionReloader(p));
        }

        private void reloadTS(IDataSourceProvider p, DataSource dataSource) {
            Stream.of(this.lookupTs(p, dataSource)).forEach(this.getTsReloader(p));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TsCollection[] lookupTsCollection(IDataSourceProvider p, DataSource dataSource) {
            HashMap hashMap = TsFactory.this.m_collections;
            synchronized (hashMap) {
                return (TsCollection[])TsFactory.this.m_collections.entrySet().stream().filter(o -> this.isRelatedTo(p, dataSource, (TsMoniker)o.getKey())).map(o -> (TsCollection)((WeakReference)o.getValue()).get()).filter(Objects::nonNull).toArray(TsCollection[]::new);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Ts.Master[] lookupTs(IDataSourceProvider p, DataSource dataSource) {
            HashMap hashMap = TsFactory.this.m_collections;
            synchronized (hashMap) {
                return (Ts.Master[])TsFactory.this.m_ts.entrySet().stream().filter(o -> this.isRelatedTo(p, dataSource, (TsMoniker)o.getKey())).map(o -> (Ts.Master)((WeakReference)o.getValue()).get()).filter(Objects::nonNull).toArray(Ts.Master[]::new);
            }
        }

        private boolean isRelatedTo(IDataSourceProvider p, DataSource dataSource, TsMoniker moniker) {
            if (p.getSource().equals(moniker.getSource())) {
                DataSet dataSet = p.toDataSet(moniker);
                return dataSet != null && dataSet.getDataSource().equals((Object)dataSource);
            }
            return false;
        }

        private Consumer<TsCollection> getTsCollectionReloader(IDataSourceProvider p) {
            return p.getAsyncMode() == TsAsyncMode.None ? o -> TsFactory.this.doLoad(o, o.getInformationType()) : o -> p.queryTsCollection(o.getMoniker(), o.getInformationType());
        }

        private Consumer<Ts.Master> getTsReloader(IDataSourceProvider p) {
            return p.getAsyncMode() == TsAsyncMode.None ? o -> TsFactory.this.doLoad(o, o.getInformationType()) : o -> p.queryTs(o.getMoniker(), o.getInformationType());
        }
    }

    private final class TsCallback
    implements Ts.FactoryCallback {
        private TsCallback() {
        }

        @Override
        public boolean load(Ts ts, TsInformationType type) {
            return TsFactory.this.load(ts, type);
        }

        @Override
        public boolean query(Ts s, TsInformationType type) {
            return TsFactory.this.query(s, type);
        }

        @Override
        public void notify(Ts s, TsInformationType type, Object sender) {
            TsFactory.this.notify(s, type, sender);
        }

        @Override
        public Ts createTs(String name, MetaData md, TsData d) {
            return TsFactory.this.createTs(name, md, d);
        }

        @Override
        public Ts createTs(String name, TsMoniker moniker, TsInformationType type) {
            return TsFactory.this.createTs(name, moniker, type);
        }
    }

    private final class TsCollectionCallback
    implements TsCollection.FactoryCallback {
        private TsCollectionCallback() {
        }

        @Override
        public boolean load(TsCollection c, TsInformationType type) {
            return TsFactory.this.load(c, type);
        }

        @Override
        public boolean query(TsCollection c, TsInformationType type) {
            return TsFactory.this.query(c, type);
        }

        @Override
        public void notify(TsCollection s, TsInformationType type, Object sender) {
            TsFactory.this.notify(s, type, sender);
        }

        @Override
        public Ts getTs(TsMoniker moniker) {
            return TsFactory.this.getTs(moniker);
        }

        @Override
        public Ts createTs(TsInformation info) {
            return TsFactory.this.createTs(info);
        }

        @Override
        public TsCollection createTsCollection(String name, TsMoniker moniker, MetaData md, Iterable<Ts> ts) {
            return TsFactory.this.createTsCollection(name, moniker, md, ts);
        }

        @Override
        public TsCollection createTsCollection(String name) {
            return TsFactory.this.createTsCollection(name);
        }
    }
}

