/*
 * Decompiled with CFR 0.152.
 */
package ec.tss;

import ec.tss.Ts;
import ec.tss.TsFactory;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tstoolkit.MetaData;
import ec.tstoolkit.timeseries.simplets.TsData;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TsInformation {
    public TsMoniker moniker;
    public String name;
    public MetaData metaData;
    public TsData data;
    public TsInformationType type;
    public String invalidDataCause;

    public TsInformation() {
        this.moniker = TsMoniker.createAnonymousMoniker();
        this.type = TsInformationType.UserDefined;
    }

    @Deprecated
    public TsInformation(Ts ts, TsInformationType type) {
        this.name = ts.getRawName();
        this.moniker = ts.getMoniker();
        this.type = type;
        ts.load(type);
        if (this.hasData()) {
            this.data = ts.getTsData();
        }
        if (this.hasMetaData()) {
            this.metaData = ts.getMetaData();
        }
        this.invalidDataCause = ts.getInvalidDataCause();
    }

    public TsInformation(String name, TsMoniker moniker, TsInformationType type) {
        this.name = name;
        this.moniker = moniker;
        this.type = type;
    }

    public boolean hasData() {
        return this.type == TsInformationType.All || this.type == TsInformationType.Data || this.type == TsInformationType.UserDefined && this.data != null;
    }

    public boolean hasMetaData() {
        return this.type == TsInformationType.All || this.type == TsInformationType.MetaData || this.type == TsInformationType.UserDefined && this.metaData != null;
    }

    public @NonNull Ts toTs() {
        Ts result = TsFactory.instance.createTs(this.name, this.moniker, this.metaData, this.data);
        if (this.data == null) {
            result.setInvalidDataCause(this.invalidDataCause);
        }
        return result;
    }
}

