/*
 * Decompiled with CFR 0.152.
 */
package ec.tss;

import ec.tstoolkit.design.IntValue;

public enum TsInformationType implements IntValue
{
    UserDefined(-1),
    None(0),
    Definition(1),
    MetaData(2),
    BaseInformation(3),
    Data(4),
    All(5);

    private final int value;

    private TsInformationType(int value) {
        this.value = value;
    }

    public int intValue() {
        return this.value;
    }

    public boolean needsData() {
        return this == Data || this == All;
    }

    public TsInformationType union(TsInformationType rtype) {
        if (this == rtype) {
            return this;
        }
        if (this == All || rtype == All) {
            return All;
        }
        if (this == None) {
            return rtype;
        }
        if (rtype == None) {
            return this;
        }
        if (this == Data && rtype == Definition) {
            return Data;
        }
        if (this == Definition && rtype == Data) {
            return Data;
        }
        return All;
    }

    public boolean encompass(TsInformationType newtype) {
        switch (newtype.ordinal()) {
            case 6: {
                return this == All;
            }
            case 5: {
                return this == Data || this == All;
            }
            case 3: {
                return this == MetaData || this == All;
            }
            case 2: {
                return this == All || this == Data || this == Definition;
            }
        }
        return true;
    }
}

