/*
 * Decompiled with CFR 0.152.
 */
package ec.tss;

import ec.tstoolkit.design.Internal;
import java.util.Objects;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TsMoniker
implements Comparable<TsMoniker> {
    private final @Nullable String m_source;
    private final @Nullable String m_id;
    private final @Nullable UUID uuid;

    public static @NonNull TsMoniker create(@Nullable String source, @Nullable String id) throws IllegalArgumentException {
        if (source == null && id == null) {
            return TsMoniker.createAnonymousMoniker();
        }
        if (source != null && id != null) {
            return TsMoniker.createProvidedMoniker(source, id);
        }
        throw new IllegalArgumentException();
    }

    public static @NonNull TsMoniker createAnonymousMoniker() {
        return new TsMoniker(null, null, UUID.randomUUID());
    }

    public static @NonNull TsMoniker createDynamicMoniker() {
        return new TsMoniker("dynamic", null, UUID.randomUUID());
    }

    public static @NonNull TsMoniker createProvidedMoniker(@NonNull String source, @NonNull String id) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(id, "id");
        return new TsMoniker(source, id, null);
    }

    @Internal
    static TsMoniker ofInternal(boolean dynamic, @NonNull UUID uuid) {
        Objects.requireNonNull(uuid, "uuid");
        return new TsMoniker(dynamic ? "dynamic" : null, null, uuid);
    }

    private TsMoniker(String m_source, String m_id, UUID uuid) {
        this.m_source = m_source;
        this.m_id = m_id;
        this.uuid = uuid;
    }

    @Deprecated
    public TsMoniker() {
        this(null, null, UUID.randomUUID());
    }

    public TsMoniker(@NonNull String source, @NonNull String id) throws IllegalArgumentException {
        if (source == null || id == null) {
            throw new IllegalArgumentException("source and id cannot be null");
        }
        this.m_source = source;
        this.m_id = id;
        this.uuid = null;
    }

    public @Nullable String getId() {
        return this.m_id;
    }

    public @Nullable String getSource() {
        return this.m_source;
    }

    @Internal
    UUID getUuid() {
        return this.uuid;
    }

    public @NonNull Type getType() {
        if (this.m_source == null) {
            return Type.ANONYMOUS;
        }
        if (this.m_source.equals("dynamic")) {
            return Type.DYNAMIC;
        }
        return Type.PROVIDED;
    }

    @Deprecated
    public boolean isAnonymous() {
        return this.m_id == null;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TsMoniker && this.equals((TsMoniker)obj);
    }

    private boolean equals(TsMoniker other) {
        return Objects.equals(this.m_source, other.m_source) && Objects.equals(this.m_id, other.m_id) && Objects.equals(this.uuid, other.uuid);
    }

    public int hashCode() {
        switch (this.getType().ordinal()) {
            case 0: 
            case 1: {
                return this.uuid.hashCode();
            }
            case 2: {
                return 0 ^ this.m_source.hashCode() ^ this.m_id.hashCode();
            }
        }
        throw new RuntimeException();
    }

    public String toString() {
        switch (this.getType().ordinal()) {
            case 0: 
            case 1: {
                return this.uuid.toString();
            }
            case 2: {
                return this.m_source + "<@>" + this.m_id;
            }
        }
        throw new RuntimeException();
    }

    @Override
    public int compareTo(TsMoniker o) {
        if (this.uuid != null) {
            if (o.uuid != null) {
                return this.uuid.compareTo(o.uuid);
            }
            return -1;
        }
        if (o.uuid != null) {
            return 1;
        }
        int r0 = this.m_source.compareTo(o.m_source);
        return r0 != 0 ? r0 : this.m_id.compareTo(o.m_id);
    }

    public static enum Type {
        ANONYMOUS,
        DYNAMIC,
        PROVIDED;

    }
}

