/*
 * Decompiled with CFR 0.152.
 */
package ec.tss;

import ec.tss.Ts;
import ec.tss.TsCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class TsWorkspace
implements Iterable<TsCollection> {
    private boolean m_bDirty;
    private boolean m_bRead;
    private ArrayList<TsCollection> m_tsdata = new ArrayList();
    private String m_name;

    public TsWorkspace() {
    }

    public TsWorkspace(Iterable<TsCollection> coll) {
        for (TsCollection c : coll) {
            this.m_tsdata.add(c);
        }
    }

    public int add(TsCollection collection) {
        if (this.m_bRead) {
            return -1;
        }
        this.m_tsdata.add(collection);
        this.m_bDirty = true;
        return this.m_tsdata.size() - 1;
    }

    public void clear() {
        if (this.m_bRead) {
            return;
        }
        if (!this.m_tsdata.isEmpty()) {
            this.m_tsdata.clear();
            this.m_bDirty = true;
        }
    }

    public boolean contains(String name) {
        for (TsCollection coll : this.m_tsdata) {
            if (!coll.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public List<TsCollection> elements() {
        return this.m_tsdata;
    }

    public TsCollection get(int icoll) {
        if (icoll < 0 || icoll >= this.m_tsdata.size()) {
            return null;
        }
        return this.m_tsdata.get(icoll);
    }

    public Ts get(int icoll, int ipos) {
        if (icoll < 0 || icoll >= this.m_tsdata.size() || ipos < 0 || ipos >= this.m_tsdata.get(icoll).getCount()) {
            return null;
        }
        return this.m_tsdata.get(icoll).get(ipos);
    }

    public int getCount() {
        return this.m_tsdata.size();
    }

    public String getName() {
        return this.m_name;
    }

    public int getTSCount() {
        int n = 0;
        for (TsCollection c : this.m_tsdata) {
            n += c.getCount();
        }
        return n;
    }

    public boolean isDirty() {
        return this.m_bDirty;
    }

    public boolean isReadOnly() {
        return this.m_bRead;
    }

    @Override
    public Iterator<TsCollection> iterator() {
        return this.m_tsdata.iterator();
    }

    public Stream<TsCollection> stream() {
        return this.m_tsdata.stream();
    }

    public void removeTsCollection(TsCollection coll) {
        if (this.m_bRead) {
            return;
        }
        this.m_tsdata.remove(coll);
        this.m_bDirty = true;
    }

    public void setDirty(boolean value) {
        this.m_bDirty = value;
    }

    public void setName(String value) {
        this.m_name = value;
    }

    public void setReadOnly(boolean value) {
        this.m_bRead = value;
    }
}

