/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.businesscycle.documents;

import ec.satoolkit.SaSpecification;
import ec.tss.businesscycle.processors.HodrickPrescottProcessingFactory;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.InformationSet;
import java.util.Map;

public class HodrickPrescottSpecification
implements IProcSpecification,
Cloneable {
    public static final double DEF_LAMBDA = 1600.0;
    private Target target = Target.Original;
    private SaSpecification saSpec = new SaSpecification();
    private double lambda = 1600.0;
    private double cycleLength = 0.0;
    public static final String CYCLELENGTH = "cyclelength";
    public static final String LAMBDA = "lambda";
    public static final String SASPEC = "saspec";
    public static final String TARGET = "target";

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item((String)prefix, (String)TARGET), String.class);
        dic.put(InformationSet.item((String)prefix, (String)LAMBDA), Double.class);
        dic.put(InformationSet.item((String)prefix, (String)CYCLELENGTH), Double.class);
        SaSpecification.fillDictionary((String)InformationSet.item((String)prefix, (String)SASPEC), dic);
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public SaSpecification getSaSpecification() {
        return this.saSpec;
    }

    public void setSaSpecification(SaSpecification saSpec) {
        this.saSpec = saSpec;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double lambda) {
        this.lambda = lambda;
    }

    public double getCycleLength() {
        return this.cycleLength;
    }

    public void setCycleLength(double cycleLength) {
        this.cycleLength = cycleLength;
    }

    public boolean isDefault() {
        return this.saSpec.isDefault() && this.cycleLength == 0.0 && this.target == Target.Original && this.lambda == 1600.0;
    }

    public HodrickPrescottSpecification clone() {
        try {
            HodrickPrescottSpecification spec = (HodrickPrescottSpecification)super.clone();
            spec.setSaSpecification(this.getSaSpecification().clone());
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        info.add("algorithm", (Object)HodrickPrescottProcessingFactory.DESCRIPTOR);
        InformationSet saspec = this.saSpec.write(verbose);
        if (saspec != null) {
            info.set(SASPEC, (Object)saspec);
        }
        if (this.target != Target.Original || verbose) {
            info.set(TARGET, (Object)this.target.name());
        }
        if (this.lambda != 1600.0 || verbose) {
            info.set(LAMBDA, (Object)this.lambda);
        }
        if (this.cycleLength != 0.0 || verbose) {
            info.set(CYCLELENGTH, (Object)this.cycleLength);
        }
        return info;
    }

    public boolean read(InformationSet info) {
        try {
            Double c;
            Double l;
            String t;
            InformationSet spec = info.getSubSet(SASPEC);
            if (spec != null) {
                this.saSpec.read(spec);
            }
            if ((t = (String)info.get(TARGET, String.class)) != null) {
                this.target = Target.valueOf(t);
            }
            if ((l = (Double)info.get(LAMBDA, Double.class)) != null) {
                this.lambda = l;
            }
            if ((c = (Double)info.get(CYCLELENGTH, Double.class)) != null) {
                this.cycleLength = c;
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    public static enum Target {
        Original,
        Trend,
        Sa;

    }
}

