/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.businesscycle.processors;

import ec.businesscycle.impl.HodrickPrescott;
import ec.satoolkit.ISaSpecification;
import ec.satoolkit.ISeriesDecomposition;
import ec.satoolkit.SaSpecification;
import ec.satoolkit.algorithm.implementation.TramoSeatsProcessingFactory;
import ec.satoolkit.algorithm.implementation.X13ProcessingFactory;
import ec.satoolkit.tramoseats.TramoSeatsSpecification;
import ec.satoolkit.x13.X13Specification;
import ec.tss.businesscycle.documents.BusinessCycleDecomposition;
import ec.tss.businesscycle.documents.HodrickPrescottSpecification;
import ec.tstoolkit.BaseException;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.IProcessingNode;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.algorithm.SequentialProcessing;
import ec.tstoolkit.algorithm.SingleTsData;
import ec.tstoolkit.algorithm.SingleTsDataProcessing;
import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class HodrickPrescottProcessingFactory
implements IProcessingFactory<HodrickPrescottSpecification, TsData, CompositeResults> {
    public static final String FAMILY = "Business Cycle";
    public static final String METHOD = "hodrickprescott";
    public static final String VERSION = "0.1.0.0";
    public static final AlgorithmDescriptor DESCRIPTOR = new AlgorithmDescriptor("Business Cycle", "hodrickprescott", "0.1.0.0");
    public static final String INPUT = "input";
    public static final String SA = "sa";
    public static final String BC = "bc";
    public static final int MAX_REPEAT_COUNT = 50;
    public static final HodrickPrescottProcessingFactory instance = new HodrickPrescottProcessingFactory();

    public void dispose() {
    }

    public AlgorithmDescriptor getInformation() {
        return DESCRIPTOR;
    }

    public boolean canHandle(IProcSpecification spec) {
        return spec instanceof HodrickPrescottSpecification;
    }

    public IProcessing<TsData, CompositeResults> generateProcessing(HodrickPrescottSpecification specification, ProcessingContext context) {
        return HodrickPrescottProcessingFactory.create(specification);
    }

    public IProcessing<TsData, CompositeResults> generateProcessing(HodrickPrescottSpecification specification) {
        return HodrickPrescottProcessingFactory.create(specification);
    }

    protected static TsData series(Map<String, IProcResults> results) {
        IProcResults input = results.get(INPUT);
        if (input == null || !(input instanceof SingleTsData)) {
            return null;
        }
        SingleTsData sdata = (SingleTsData)input;
        return sdata.getSeries();
    }

    protected static ISeriesDecomposition getSa(Map<String, IProcResults> results) {
        IProcResults decomp = results.get(SA);
        if (decomp == null || !(decomp instanceof ISeriesDecomposition)) {
            return null;
        }
        return (ISeriesDecomposition)decomp;
    }

    private static SequentialProcessing<TsData> create(HodrickPrescottSpecification xspec) {
        SequentialProcessing processing = new SequentialProcessing();
        processing.add(HodrickPrescottProcessingFactory.createInitialStep(new TsPeriodSelector()));
        processing.add(HodrickPrescottProcessingFactory.createSaStep(xspec.getSaSpecification()));
        processing.add(HodrickPrescottProcessingFactory.createHpStep(xspec));
        return processing;
    }

    public static CompositeResults process(TsData s, HodrickPrescottSpecification xspec) {
        SequentialProcessing<TsData> processing = HodrickPrescottProcessingFactory.create(xspec);
        return processing.process((Object)s);
    }

    protected static IProcessingNode<TsData> createInitialStep(final TsPeriodSelector selector) {
        return new IProcessingNode<TsData>(){

            public String getName() {
                return HodrickPrescottProcessingFactory.INPUT;
            }

            public String getPrefix() {
                return null;
            }

            public IProcessing.Status process(TsData input, Map<String, IProcResults> results) {
                SingleTsDataProcessing processing = new SingleTsDataProcessing(selector);
                processing.setValidation(new SingleTsDataProcessing.Validation(){

                    public boolean validate(TsData s) {
                        HodrickPrescottProcessingFactory.testSeries(s);
                        return true;
                    }
                });
                SingleTsData rslt = processing.process(input);
                if (rslt != null) {
                    results.put(HodrickPrescottProcessingFactory.INPUT, (IProcResults)rslt);
                    return IProcessing.Status.Valid;
                }
                return IProcessing.Status.Invalid;
            }
        };
    }

    protected static IProcessingNode<TsData> createSaStep(final SaSpecification spec) {
        return new IProcessingNode<TsData>(){

            public String getName() {
                return HodrickPrescottProcessingFactory.SA;
            }

            public String getPrefix() {
                return HodrickPrescottProcessingFactory.SA;
            }

            public IProcessing.Status process(TsData ts, Map<String, IProcResults> results) {
                ISaSpecification xspec = spec.getFullSpecification();
                if (xspec == null) {
                    return IProcessing.Status.Valid;
                }
                TsData s = HodrickPrescottProcessingFactory.series(results);
                if (s == null) {
                    s = ts;
                }
                if (s == null) {
                    return IProcessing.Status.Invalid;
                }
                try {
                    ISeriesDecomposition sa = null;
                    if (xspec instanceof TramoSeatsSpecification) {
                        sa = (ISeriesDecomposition)TramoSeatsProcessingFactory.process((TsData)s, (TramoSeatsSpecification)((TramoSeatsSpecification)xspec)).get("final", ISeriesDecomposition.class);
                    } else if (xspec instanceof X13Specification) {
                        sa = (ISeriesDecomposition)X13ProcessingFactory.process((TsData)s, (X13Specification)((X13Specification)xspec)).get("final", ISeriesDecomposition.class);
                    }
                    if (sa == null) {
                        return IProcessing.Status.Invalid;
                    }
                    results.put(HodrickPrescottProcessingFactory.SA, (IProcResults)sa);
                    return IProcessing.Status.Valid;
                }
                catch (Exception err) {
                    return IProcessing.Status.Invalid;
                }
            }
        };
    }

    protected static IProcessingNode<TsData> createHpStep(final HodrickPrescottSpecification spec) {
        return new IProcessingNode<TsData>(){

            public String getName() {
                return HodrickPrescottProcessingFactory.BC;
            }

            public String getPrefix() {
                return HodrickPrescottProcessingFactory.BC;
            }

            public IProcessing.Status process(TsData ts, Map<String, IProcResults> results) {
                boolean mul = false;
                TsData s = null;
                if (spec.getTarget() == HodrickPrescottSpecification.Target.Original) {
                    s = HodrickPrescottProcessingFactory.series(results);
                    if (s == null) {
                        s = ts;
                    }
                } else {
                    ISeriesDecomposition sa = HodrickPrescottProcessingFactory.getSa(results);
                    if (sa == null) {
                        return IProcessing.Status.Invalid;
                    }
                    mul = sa.getMode().isMultiplicative();
                    switch (spec.getTarget()) {
                        case Trend: {
                            s = sa.getSeries(ComponentType.Trend, ComponentInformation.Value);
                            break;
                        }
                        case Sa: {
                            s = sa.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value);
                            break;
                        }
                        case Original: {
                            s = sa.getSeries(ComponentType.Series, ComponentInformation.Value);
                        }
                    }
                    if (s == null) {
                        return IProcessing.Status.Invalid;
                    }
                }
                try {
                    TsData input = s;
                    if (mul) {
                        input = input.log();
                    }
                    HodrickPrescott hp = new HodrickPrescott();
                    double lambda = spec.getLambda();
                    if (spec.getCycleLength() != 0.0) {
                        lambda = HodrickPrescottProcessingFactory.defaultLambda(spec.getCycleLength(), s.getFrequency().intValue());
                    }
                    hp.setLambda(lambda);
                    if (!hp.process(input.internalStorage())) {
                        return IProcessing.Status.Invalid;
                    }
                    TsData t = new TsData(s.getStart(), hp.getSignal(), false);
                    if (mul) {
                        t = t.exp();
                    }
                    TsData c = mul ? TsData.divide((TsData)s, (TsData)t) : TsData.subtract((TsData)s, (TsData)t);
                    BusinessCycleDecomposition bc = new BusinessCycleDecomposition(mul, s, t, c);
                    results.put(HodrickPrescottProcessingFactory.BC, bc);
                    return IProcessing.Status.Valid;
                }
                catch (Exception err) {
                    return IProcessing.Status.Invalid;
                }
            }
        };
    }

    public static double defaultLambda(double ylen, int freq) {
        double w = Math.PI * 2 / ((double)freq * ylen);
        double x = 1.0 - Math.cos(w);
        return 0.75 / (x * x);
    }

    private static void testSeries(TsData y) {
        int ifreq;
        if (y == null) {
            throw new BaseException("Missing series");
        }
        int nz = y.getLength();
        if (nz < Math.max(8, 3 * (ifreq = y.getFrequency().intValue()))) {
            throw new BaseException("Not enough data");
        }
        int nrepeat = y.getRepeatCount();
        if (nrepeat > 50 * nz / 100) {
            throw new BaseException("Too many identical values");
        }
    }

    public Map<String, Class> getSpecificationDictionary(Class<HodrickPrescottSpecification> specClass) {
        HashMap<String, Class> dic = new HashMap<String, Class>();
        HodrickPrescottSpecification.fillDictionary(null, dic);
        return dic;
    }

    public Map<String, Class> getOutputDictionary(boolean compact) {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        BusinessCycleDecomposition.fillDictionary(BC, dic, compact);
        return dic;
    }
}

