/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.disaggregation.documents;

import ec.benchmarking.simplets.Calendarization;
import ec.tss.disaggregation.documents.CalendarizationResults;
import ec.tss.disaggregation.documents.CalendarizationSpecification;
import ec.tss.disaggregation.processors.CalendarizationProcessor;
import ec.tss.documents.ActiveDocument;
import ec.tss.documents.DocumentManager;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.utilities.StringFormatter;
import java.util.ArrayList;
import java.util.List;

public class CalendarizationDocument
extends ActiveDocument<CalendarizationSpecification, List<Calendarization.PeriodObs>, CalendarizationResults>
implements Cloneable {
    private final CalendarizationProcessor factory_ = CalendarizationProcessor.instance;
    public static final String START = "start";
    public static final String END = "end";
    public static final String VALUE = "value";

    public CalendarizationDocument() {
        super(CalendarizationProcessor.DESCRIPTOR.name);
        this.setSpecification(new CalendarizationSpecification());
    }

    public CalendarizationDocument(ProcessingContext context) {
        super(CalendarizationProcessor.DESCRIPTOR.name, context);
        this.setSpecification(new CalendarizationSpecification());
    }

    @Override
    public String getDescription() {
        return this.factory_.getInformation().name;
    }

    protected void updateLinks() {
        DocumentManager.instance.update(this);
    }

    @Override
    protected CalendarizationResults recalc(CalendarizationSpecification spec, List<Calendarization.PeriodObs> input) {
        return (CalendarizationResults)this.factory_.generateProcessing(spec, (ProcessingContext)null).process(input);
    }

    @Override
    public void setInput(List<Calendarization.PeriodObs> input) {
        if (input == null || this.getInput() != null && ((List)this.getInput()).equals(input)) {
            return;
        }
        super.setInput(input);
    }

    public InformationSet write(boolean verbose) {
        InformationSet info = super.write(verbose);
        info.add("algorithm", (Object)this.factory_.getInformation());
        List obs = (List)this.getInput();
        InformationSet inputs = info.subSet("input");
        for (int i = 0; i < obs.size(); ++i) {
            InformationSet observation = inputs.subSet("Obs(" + i + ")");
            observation.add(START, (Object)StringFormatter.convert((Day)((Calendarization.PeriodObs)obs.get((int)i)).start));
            observation.add(END, (Object)StringFormatter.convert((Day)((Calendarization.PeriodObs)obs.get((int)i)).end));
            observation.add(VALUE, (Object)((Calendarization.PeriodObs)obs.get((int)i)).value);
        }
        info.set("specification", (Object)((CalendarizationSpecification)this.getSpecification()).write(verbose));
        return info;
    }

    public boolean read(InformationSet info) {
        InformationSet ispec;
        List sets;
        if (!super.read(info)) {
            return false;
        }
        AlgorithmDescriptor algorithm = (AlgorithmDescriptor)info.get("algorithm", AlgorithmDescriptor.class);
        if (algorithm == null || !this.factory_.getInformation().isCompatible(algorithm)) {
            return false;
        }
        InformationSet input = info.getSubSet("input");
        if (input != null && (sets = input.select(InformationSet.class)) != null) {
            ArrayList<Calendarization.PeriodObs> obs = new ArrayList<Calendarization.PeriodObs>();
            for (Information s : sets) {
                Day start = StringFormatter.convertDay((String)((String)((InformationSet)s.value).get(START, String.class)));
                Day end = StringFormatter.convertDay((String)((String)((InformationSet)s.value).get(END, String.class)));
                double value = (Double)((InformationSet)s.value).get(VALUE, Double.class);
                obs.add(new Calendarization.PeriodObs(start, end, value));
            }
            super.setInput(obs, true);
        }
        if ((ispec = info.getSubSet("specification")) != null) {
            CalendarizationSpecification spec = new CalendarizationSpecification();
            if (spec.read(ispec)) {
                this.setSpecification(spec, true);
                return true;
            }
            return false;
        }
        return true;
    }
}

