/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.disaggregation.documents;

import ec.tss.disaggregation.processors.CalendarizationProcessor;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class CalendarizationSpecification
implements IProcSpecification,
Cloneable {
    public static final String WEIGHTS = "dailyweights";
    public static final String AGGREGATE_FREQUENCY = "aggregatefrequency";
    private double[] weights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private TsFrequency aggFrequency = TsFrequency.Monthly;

    public double[] getWeights() {
        return this.weights;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }

    public TsFrequency getAggFrequency() {
        return this.aggFrequency;
    }

    public void setAggFrequency(TsFrequency aggFrequency) {
        this.aggFrequency = aggFrequency;
    }

    public CalendarizationSpecification clone() {
        CalendarizationSpecification clone = new CalendarizationSpecification();
        clone.setAggFrequency(this.aggFrequency);
        clone.setWeights(Arrays.copyOf(this.weights, this.weights.length));
        return clone;
    }

    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        info.set("algorithm", (Object)CalendarizationProcessor.DESCRIPTOR);
        if (this.weights != null || verbose) {
            info.set(WEIGHTS, (Object)this.weights);
        }
        if (this.aggFrequency != null || verbose) {
            info.set(AGGREGATE_FREQUENCY, (Object)this.aggFrequency);
        }
        return info;
    }

    public boolean read(InformationSet info) {
        String f;
        double[] w = (double[])info.get(WEIGHTS, double[].class);
        if (w != null) {
            this.weights = w;
        }
        if ((f = (String)info.get(AGGREGATE_FREQUENCY, String.class)) != null) {
            this.aggFrequency = TsFrequency.valueOf((String)f);
        }
        return true;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof CalendarizationSpecification && this.equals((CalendarizationSpecification)obj);
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Arrays.hashCode(this.weights);
        hash = 89 * hash + Objects.hashCode(this.aggFrequency);
        return hash;
    }

    public boolean equals(CalendarizationSpecification spec) {
        return Arrays.equals(this.weights, spec.getWeights()) && this.aggFrequency.equals((Object)spec.getAggFrequency());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Daily Weights = (");
        for (int i = 0; i < this.weights.length; ++i) {
            builder.append(String.valueOf(this.weights[i]));
            builder.append(i <= this.weights.length - 1 ? ", " : "), ");
        }
        builder.append("Agg. Freq. = ").append(this.aggFrequency.toString());
        return builder.toString();
    }

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item((String)prefix, (String)WEIGHTS), double[].class);
        dic.put(InformationSet.item((String)prefix, (String)AGGREGATE_FREQUENCY), TsFrequency.class);
    }
}

