/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.disaggregation.documents;

import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.InformationSet;
import java.util.Map;

public class CholetteSpecification
implements IProcSpecification,
Cloneable {
    public static double DEF_LAMBDA = 1.0;
    public static double DEF_RHO = 1.0;
    private double rho_ = DEF_RHO;
    private double lambda_ = DEF_LAMBDA;
    public static final String LAMBDA = "lambda";
    public static final String RHO = "rho";
    private static final String[] DICTIONARY = new String[]{"lambda", "rho"};

    public double getRho() {
        return this.rho_;
    }

    public void setRho(double rho) {
        this.rho_ = rho;
    }

    public double getLambda() {
        return this.lambda_;
    }

    public void setLambda(double lambda) {
        this.lambda_ = lambda;
    }

    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        info.add(LAMBDA, (Object)this.lambda_);
        info.add(RHO, (Object)this.rho_);
        return info;
    }

    public boolean read(InformationSet info) {
        try {
            Double lambda;
            Double rho = (Double)info.get(RHO, Double.class);
            if (rho != null) {
                this.rho_ = rho;
            }
            if ((lambda = (Double)info.get(LAMBDA, Double.class)) != null) {
                this.lambda_ = lambda;
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(RHO, Double.class);
        dic.put(LAMBDA, Double.class);
    }

    public CholetteSpecification clone() {
        try {
            return (CholetteSpecification)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(CholetteSpecification other) {
        return this.rho_ == other.rho_ && this.lambda_ == other.lambda_;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof CholetteSpecification && this.equals((CholetteSpecification)obj);
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + (int)(Double.doubleToLongBits(this.rho_) ^ Double.doubleToLongBits(this.rho_) >>> 32);
        hash = 29 * hash + (int)(Double.doubleToLongBits(this.lambda_) ^ Double.doubleToLongBits(this.lambda_) >>> 32);
        return hash;
    }
}

