/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.disaggregation.documents;

import ec.tss.disaggregation.processors.DentonProcessor;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.Map;
import java.util.Objects;

public class DentonSpecification
implements IProcSpecification,
Cloneable {
    public static final String MUL = "multiplicative";
    public static final String DIFF = "differencing";
    public static final String MOD = "modified";
    public static final String TYPE = "type";
    public static final String FREQ = "defaultfrequency";
    private boolean mul_ = true;
    private boolean mod_ = true;
    private int diff_ = 1;
    private TsAggregationType type_ = TsAggregationType.Average;
    private TsFrequency defaultFrequency_ = TsFrequency.Quarterly;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.mul_ ? "Mul. " : "Add. ").append("denton ");
        builder.append(" (D=").append(this.diff_).append(", mod=").append(this.mod_).append(')');
        return builder.toString();
    }

    public boolean isMultiplicative() {
        return this.mul_;
    }

    public void setMultiplicative(boolean mul) {
        this.mul_ = mul;
    }

    public boolean isModifiedDenton() {
        return this.mod_;
    }

    public void setModifiedDenton(boolean mod) {
        this.mod_ = mod;
    }

    public int getDifferencingOrder() {
        return this.diff_;
    }

    public void setDifferencingOrder(int diff) {
        this.diff_ = diff;
    }

    public TsAggregationType getAggregationType() {
        return this.type_;
    }

    public void setAggregationType(TsAggregationType type) {
        this.type_ = type;
    }

    public TsFrequency getDefaultFrequency() {
        return this.defaultFrequency_;
    }

    public void setDefaultFrequency(TsFrequency freq) {
        this.defaultFrequency_ = freq;
    }

    public DentonSpecification clone() {
        try {
            return (DentonSpecification)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        info.set("algorithm", (Object)DentonProcessor.DESCRIPTOR);
        info.set(MUL, (Object)this.mul_);
        if (!this.mod_ || verbose) {
            info.set(MOD, (Object)this.mod_);
        }
        if (this.diff_ != 1 || verbose) {
            info.set(DIFF, (Object)this.diff_);
        }
        if (this.type_ != TsAggregationType.Sum || verbose) {
            info.set(TYPE, (Object)this.type_.name());
        }
        return info;
    }

    public boolean read(InformationSet info) {
        String n;
        String type;
        Integer diff;
        Boolean mod;
        Boolean mul = (Boolean)info.get(MUL, Boolean.class);
        if (mul != null) {
            this.mul_ = mul;
        }
        if ((mod = (Boolean)info.get(MOD, Boolean.class)) != null) {
            this.mod_ = mod;
        }
        if ((diff = (Integer)info.get(DIFF, Integer.class)) != null) {
            this.diff_ = diff;
        }
        if ((type = (String)info.get(TYPE, String.class)) != null) {
            this.type_ = TsAggregationType.valueOf((String)type);
        }
        if ((n = (String)info.get(FREQ, String.class)) != null) {
            this.defaultFrequency_ = TsFrequency.valueOf((String)n);
        }
        if (this.defaultFrequency_ != TsFrequency.Quarterly) {
            info.set(FREQ, (Object)this.defaultFrequency_.name());
        }
        return true;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof DentonSpecification && this.equals((DentonSpecification)obj);
    }

    public int hashCode() {
        int hash = 5;
        hash = 13 * hash + (this.mul_ ? 1 : 0);
        hash = 13 * hash + (this.mod_ ? 1 : 0);
        hash = 13 * hash + this.diff_;
        hash = 13 * hash + Objects.hashCode(this.type_);
        return hash;
    }

    public boolean equals(DentonSpecification spec) {
        return spec.mod_ == this.mod_ && spec.mul_ == this.mul_ && spec.diff_ == this.diff_ && spec.type_ == this.type_ && spec.defaultFrequency_ == this.defaultFrequency_;
    }

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item((String)prefix, (String)MUL), Boolean.class);
        dic.put(InformationSet.item((String)prefix, (String)MOD), Boolean.class);
        dic.put(InformationSet.item((String)prefix, (String)DIFF), Integer.class);
        dic.put(InformationSet.item((String)prefix, (String)TYPE), String.class);
        dic.put(InformationSet.item((String)prefix, (String)FREQ), String.class);
    }
}

