/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.disaggregation.documents;

import ec.benchmarking.simplets.TsDisaggregation;
import ec.tstoolkit.Parameter;
import ec.tstoolkit.ParameterType;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.DiffuseConcentratedLikelihood;
import ec.tstoolkit.eco.ILikelihood;
import ec.tstoolkit.information.InformationMapping;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DisaggregationResults
implements IProcResults {
    public static final String DISAGGREGATION = "disaggregation";
    public static final String LDISAGGREGATION = "lower bound";
    public static final String UDISAGGREGATION = "upper bound";
    public static final String EDISAGGREGATION = "disggregationError";
    public static final String RESIDUALS = "residuals";
    public static final String REGEFFECT = "regression effect";
    public static final String SMOOTHING = "smoothing effect";
    private final TsDisaggregation<? extends ISsf> result;
    private final int nindicators;
    private static final InformationMapping<DisaggregationResults> MAPPING = new InformationMapping(DisaggregationResults.class);

    public DisaggregationResults(TsDisaggregation<? extends ISsf> disaggregation, int nindics) {
        this.result = disaggregation;
        this.nindicators = nindics;
    }

    public DiffuseConcentratedLikelihood getLikelihood() {
        return this.result.getLikelihood();
    }

    public LikelihoodStatistics getLikelihoodStatistics() {
        DiffuseConcentratedLikelihood ll = this.result.getLikelihood();
        IParametricMapping mapping = this.result.getMapping();
        return LikelihoodStatistics.create((ILikelihood)ll, (int)ll.getN(), (int)(mapping == null ? 0 : mapping.getDim()), (double)0.0);
    }

    public IFunction getEstimationFunction() {
        return this.result.getEstimationFunction();
    }

    public IFunctionInstance getMin() {
        return this.result.getMin();
    }

    public Parameter getEstimatedParameter() {
        Matrix i = this.result.getObservedInformation();
        if (i == null) {
            return null;
        }
        IParametricMapping mapping = this.result.getMapping();
        IReadDataBlock p = mapping.map((Object)this.result.getEstimatedSsf());
        Parameter x = new Parameter(p.get(0), ParameterType.Estimated);
        x.setStde(Math.sqrt(1.0 / i.get(0, 0)));
        return x;
    }

    public ISsf getEstimatedSsf() {
        return this.result.getEstimatedSsf();
    }

    public boolean contains(String id) {
        return MAPPING.contains(id);
    }

    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>();
        DisaggregationResults.fillDictionary(null, map, false);
        return map;
    }

    public <T> T getData(String id, Class<T> tclass) {
        if (MAPPING.contains(id)) {
            return (T)MAPPING.getData((Object)this, id, tclass);
        }
        return null;
    }

    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.emptyList();
    }

    public static void fillDictionary(String prefix, Map<String, Class> map, boolean compact) {
        MAPPING.fillDictionary(prefix, map, compact);
    }

    public static InformationMapping<DisaggregationResults> getMapping() {
        return MAPPING;
    }

    public static <T> void setMapping(String name, Class<T> tclass, Function<DisaggregationResults, T> extractor) {
        MAPPING.set(name, tclass, extractor);
    }

    public static <T> void setTsData(String name, Function<DisaggregationResults, TsData> extractor) {
        MAPPING.set(name, extractor);
    }

    static {
        MAPPING.set(DISAGGREGATION, source -> source.result.getSmoothedSeries());
        MAPPING.set(EDISAGGREGATION, source -> source.result.getSmoothedSeriesVariance().sqrt());
        MAPPING.set(LDISAGGREGATION, source -> {
            TsData s = source.result.getSmoothedSeries();
            TsData e = source.result.getSmoothedSeriesVariance().sqrt();
            e.apply(x -> -2.0 * x);
            return TsData.add((TsData)s, (TsData)e);
        });
        MAPPING.set(UDISAGGREGATION, source -> {
            TsData s = source.result.getSmoothedSeries();
            TsData e = source.result.getSmoothedSeriesVariance().sqrt();
            e.apply(x -> 2.0 * x);
            return TsData.add((TsData)s, (TsData)e);
        });
        MAPPING.set(RESIDUALS, source -> source.result.getFullResiduals());
        MAPPING.set(SMOOTHING, source -> {
            if (source.nindicators == 0) {
                return null;
            }
            TsData y = source.result.getSmoothedSeries();
            TsData regs = source.getData(REGEFFECT, TsData.class);
            return TsData.subtract((TsData)y, (TsData)regs);
        });
        MAPPING.set(REGEFFECT, source -> {
            if (source.nindicators == 0) {
                return null;
            }
            TsDomain dom = source.result.getData().hEDom;
            DataBlock d = new DataBlock(dom.getLength());
            double[] b = source.getLikelihood().getB();
            Matrix matrix = source.result.getModel().getX().all().matrix(dom);
            int i = b.length - source.nindicators;
            int j = matrix.getColumnsCount() - source.nindicators;
            while (i < b.length) {
                d.addAY(b[i], matrix.column(j));
                ++i;
                ++j;
            }
            return new TsData(dom.getStart(), (IReadDataBlock)d);
        });
    }
}

