/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.disaggregation.documents;

import ec.benchmarking.simplets.TsDisaggregation;
import ec.tstoolkit.Parameter;
import ec.tstoolkit.ParameterType;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.PeriodSelectorType;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.Objects;

public class DisaggregationSpecification
implements IProcSpecification,
Cloneable {
    public static final double DEF_EPS = 1.0E-5;
    private Model model = Model.Ar1;
    private boolean constant = true;
    private boolean trend;
    private boolean log;
    private boolean diffuseRegressors;
    private boolean zeroinit;
    private boolean ml = true;
    private Parameter p = new Parameter();
    private double truncated = 0.0;
    private TsAggregationType type = TsAggregationType.Sum;
    private TsDisaggregation.SsfOption option = TsDisaggregation.SsfOption.DKF;
    private double eps = 1.0E-5;
    private TsPeriodSelector span = new TsPeriodSelector();
    private TsFrequency defaultFrequency = TsFrequency.Quarterly;
    public static final String SPAN = "span";
    public static final String MODEL = "model";
    public static final String PARAMETER = "parameter";
    public static final String AGGTYPE = "aggregation";
    public static final String CONSTANT = "constant";
    public static final String TREND = "trend";
    public static final String ZEROINIT = "zeroinit";
    public static final String DIFFUSEREGS = "diffuseregs";
    public static final String EPS = "precision";
    public static final String LOG = "log";
    public static final String SSF = "ssfoption";
    public static final String FREQ = "defaultfrequency";
    public static final String ML = "ml";
    public static final String TRUNCATED = "truncatedrho";

    public void reset() {
        this.model = Model.Ar1;
        this.constant = true;
        this.trend = false;
        this.log = false;
        this.diffuseRegressors = false;
        this.zeroinit = false;
        this.ml = true;
        this.p = new Parameter();
        this.type = TsAggregationType.Sum;
        this.option = TsDisaggregation.SsfOption.DKF;
        this.eps = 1.0E-5;
        this.span = new TsPeriodSelector();
    }

    public TsAggregationType getType() {
        return this.type;
    }

    public void setType(TsAggregationType type) {
        this.type = type;
    }

    public double getEpsilon() {
        return this.eps;
    }

    public void setEpsilon(double eps) {
        this.eps = eps;
    }

    public boolean isZeroInitialization() {
        return this.zeroinit;
    }

    public void setZeroInitialization(boolean zeroinit) {
        this.zeroinit = zeroinit;
    }

    public boolean isML() {
        return this.ml;
    }

    public void setML(boolean ml) {
        this.ml = ml;
    }

    public Parameter getParameter() {
        return this.p;
    }

    public void setParameter(Parameter p) {
        this.p = p;
    }

    public TsPeriodSelector getSpan() {
        return this.span;
    }

    public void setSpan(TsPeriodSelector span) {
        if (span == null) {
            throw new AssertionError((Object)"Span should not be null");
        }
        this.span = span;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model aModel) {
        this.model = aModel;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public boolean isTrend() {
        return this.trend;
    }

    public void setTrend(boolean trend) {
        this.trend = trend;
    }

    public boolean isLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public boolean isDiffuseRegression() {
        return this.diffuseRegressors;
    }

    public void setDiffuseRegression(boolean diffuseRegressors) {
        this.diffuseRegressors = diffuseRegressors;
    }

    public double getTruncatedRho() {
        return this.truncated;
    }

    public void setTruncatedRho(double lrho) {
        if (lrho > 0.0 || lrho < -1.0) {
            throw new IllegalArgumentException("Truncated value should be in [-1,0]");
        }
        this.truncated = lrho;
    }

    public TsDisaggregation.SsfOption getOption() {
        return this.option;
    }

    public void setOption(TsDisaggregation.SsfOption option) {
        this.option = option;
    }

    public TsFrequency getDefaultFrequency() {
        return this.defaultFrequency;
    }

    public void setDefaultFrequency(TsFrequency freq) {
        this.defaultFrequency = freq;
    }

    public DisaggregationSpecification clone() {
        try {
            DisaggregationSpecification spec = (DisaggregationSpecification)super.clone();
            spec.span = this.span.clone();
            spec.p = this.p.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        if (this.span != null && this.span.getType() != PeriodSelectorType.All) {
            info.set(SPAN, (Object)this.span);
        }
        info.set(MODEL, (Object)this.model.name());
        if (this.p != null && this.p.getType() != ParameterType.Undefined) {
            info.set(PARAMETER, (Object)this.p);
        }
        info.set(AGGTYPE, (Object)this.type.name());
        info.set(CONSTANT, (Object)this.constant);
        info.set(TREND, (Object)this.trend);
        info.set(FREQ, (Object)this.defaultFrequency.name());
        if (this.option != TsDisaggregation.SsfOption.DKF) {
            info.set(SSF, (Object)this.option.name());
        }
        if (this.zeroinit || verbose) {
            info.set(ZEROINIT, (Object)this.zeroinit);
        }
        if (this.log || verbose) {
            info.set(LOG, (Object)this.log);
        }
        if (this.diffuseRegressors || verbose) {
            info.set(DIFFUSEREGS, (Object)this.diffuseRegressors);
        }
        if (!this.ml || verbose) {
            info.set(ML, (Object)this.ml);
        }
        if (this.eps != 1.0E-5 || verbose) {
            info.set(EPS, (Object)this.eps);
        }
        if (this.truncated != 0.0 || verbose) {
            info.set(TRUNCATED, (Object)this.truncated);
        }
        return info;
    }

    public boolean read(InformationSet info) {
        Double e;
        Double t;
        Parameter np;
        String n;
        this.reset();
        TsPeriodSelector sel = (TsPeriodSelector)info.get(SPAN, TsPeriodSelector.class);
        if (sel != null) {
            this.span = sel;
        }
        if ((n = (String)info.get(MODEL, String.class)) == null) {
            return false;
        }
        this.model = Model.valueOf(n);
        n = (String)info.get(FREQ, String.class);
        if (n != null) {
            this.defaultFrequency = TsFrequency.valueOf((String)n);
        }
        if ((np = (Parameter)info.get(PARAMETER, Parameter.class)) != null) {
            this.p = np;
        }
        if ((n = (String)info.get(AGGTYPE, String.class)) == null) {
            return false;
        }
        this.type = TsAggregationType.valueOf((String)n);
        Boolean b = (Boolean)info.get(CONSTANT, Boolean.class);
        if (b != null) {
            this.constant = b;
        }
        if ((b = (Boolean)info.get(TREND, Boolean.class)) != null) {
            this.trend = b;
        }
        if ((n = (String)info.get((Enum)this.option, String.class)) != null) {
            this.option = TsDisaggregation.SsfOption.valueOf((String)n);
        }
        if ((b = (Boolean)info.get(ZEROINIT, Boolean.class)) != null) {
            this.zeroinit = b;
        }
        if ((b = (Boolean)info.get(LOG, Boolean.class)) != null) {
            this.log = b;
        }
        if ((b = (Boolean)info.get(DIFFUSEREGS, Boolean.class)) != null) {
            this.diffuseRegressors = b;
        }
        if ((b = (Boolean)info.get(ML, Boolean.class)) != null) {
            this.ml = b;
        }
        if ((t = (Double)info.get(TRUNCATED, Double.class)) != null) {
            this.truncated = t;
        }
        if ((e = (Double)info.get(EPS, Double.class)) != null) {
            this.eps = e;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.model == Model.Ar1) {
            builder.append("Chow-Lin");
        } else if (this.model == Model.Wn) {
            builder.append("OLS");
        } else if (this.model == Model.RwAr1) {
            builder.append("Litterman");
        } else {
            builder.append("Fernandez");
        }
        return builder.toString();
    }

    public boolean equals(DisaggregationSpecification other) {
        return other.constant == this.constant && other.diffuseRegressors == this.diffuseRegressors && other.log == this.log && other.trend == this.trend && other.zeroinit == this.zeroinit && other.type == this.type && other.defaultFrequency == this.defaultFrequency && other.eps == this.eps && other.ml == this.ml && this.truncated == other.truncated && other.model == this.model && other.option == this.option && other.p.equals(this.p) && other.span.equals(this.span);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof DisaggregationSpecification && this.equals((DisaggregationSpecification)obj);
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + Objects.hashCode((Object)this.model);
        hash = 11 * hash + (this.constant ? 1 : 0);
        hash = 11 * hash + (this.trend ? 1 : 0);
        hash = 11 * hash + (this.log ? 1 : 0);
        hash = 11 * hash + (this.ml ? 1 : 0);
        hash = 11 * hash + Objects.hashCode(this.p);
        hash = 11 * hash + Objects.hashCode(this.type);
        hash = 11 * hash + Objects.hashCode(this.defaultFrequency);
        return hash;
    }

    public static enum Model {
        Wn,
        Ar1,
        Rw,
        RwAr1,
        I2,
        I3;


        public boolean hasParameter() {
            return this == Ar1 || this == RwAr1;
        }

        public boolean isStationary() {
            return this == Ar1 || this == Wn;
        }

        public int getParametersCount() {
            return this == Ar1 || this == RwAr1 ? 1 : 0;
        }

        public int getDifferencingOrder() {
            switch (this.ordinal()) {
                case 2: 
                case 3: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
                case 5: {
                    return 3;
                }
            }
            return 0;
        }
    }
}

