/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.disaggregation.documents;

import ec.tss.disaggregation.documents.CholetteSpecification;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.utilities.Comparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MultiCholetteSpecification
implements IProcSpecification,
Cloneable {
    public static final String CONSTRAINTS = "constraints";
    public static final String CONSTRAINT = "constraint";
    public static final String PARAMETERS = "parameters";
    private CholetteSpecification cholette = new CholetteSpecification();
    private List<String> constraints = new ArrayList<String>();

    public MultiCholetteSpecification clone() {
        try {
            MultiCholetteSpecification cl = (MultiCholetteSpecification)super.clone();
            cl.cholette = this.cholette.clone();
            cl.constraints = new ArrayList<String>();
            cl.constraints.addAll(this.constraints);
            return cl;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        info.set(PARAMETERS, (Object)this.cholette.write(verbose));
        if (!this.constraints.isEmpty()) {
            InformationSet cnt = info.subSet(CONSTRAINTS);
            int idx = 1;
            for (String c : this.constraints) {
                cnt.set(CONSTRAINT + idx, (Object)c);
                ++idx;
            }
        }
        return info;
    }

    public boolean read(InformationSet info) {
        InformationSet ch = info.getSubSet(PARAMETERS);
        if (ch == null) {
            return false;
        }
        if (!this.cholette.read(info)) {
            return false;
        }
        InformationSet subSet = info.getSubSet(CONSTRAINTS);
        if (subSet != null) {
            List select = subSet.select("constraint*", String.class);
            for (Information c : select) {
                this.constraints.add((String)c.value);
            }
        }
        return true;
    }

    public CholetteSpecification getParameters() {
        return this.cholette;
    }

    public void clearConstraints() {
        this.constraints.clear();
    }

    public List<String> getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    public void addConstraint(String c) {
        this.constraints.add(c);
    }

    public boolean equals(MultiCholetteSpecification spec) {
        return this.cholette.equals(spec.cholette) && Comparator.equals(this.constraints, spec.constraints);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof MultiCholetteSpecification && this.equals((MultiCholetteSpecification)obj);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.cholette != null ? this.cholette.hashCode() : 0);
        hash = 47 * hash + (this.constraints != null ? this.constraints.hashCode() : 0);
        return hash;
    }
}

