/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.disaggregation.documents;

import ec.benchmarking.simplets.TsExpander;
import ec.tss.disaggregation.processors.TsSmoothingProcessor;
import ec.tstoolkit.Parameter;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.Map;

public class TsSmoothingSpecification
implements IProcSpecification {
    public static final String PARAM = "param";
    public static final String CNT = "constant";
    public static final String TREND = "trend";
    public static final String TYPE = "aggregationtype";
    public static final String MODEL = "model";
    public static final String NFREQ = "newfrequency";
    public static final String NB = "nb";
    public static final String NF = "nf";
    private Parameter param_ = new Parameter();
    private boolean cnt_ = false;
    private boolean trend_ = false;
    private TsAggregationType type_ = TsAggregationType.Sum;
    private TsExpander.Model model_ = TsExpander.Model.I1;
    private TsFrequency nfreq_ = TsFrequency.Monthly;
    private int nb_;
    private int nf_;

    public Parameter getParameter() {
        return this.param_;
    }

    public void setParameter(Parameter p) {
        this.param_ = p;
    }

    public TsExpander.Model getModel() {
        return this.model_;
    }

    public void setModel(TsExpander.Model model) {
        this.model_ = model;
    }

    public TsAggregationType getAggregationType() {
        return this.type_;
    }

    public void setAggregationType(TsAggregationType type) {
        this.type_ = type;
    }

    public boolean isConstant() {
        return this.cnt_;
    }

    public void setConstant(boolean c) {
        this.cnt_ = c;
    }

    public boolean isTrend() {
        return this.trend_;
    }

    public void setTrend(boolean t) {
        this.trend_ = t;
    }

    public TsFrequency getNewFrequency() {
        return this.nfreq_;
    }

    public void setNewFrequency(TsFrequency nfreq) {
        this.nfreq_ = nfreq;
    }

    public int getBackcastsCount() {
        return this.nb_;
    }

    public void setBackcastsCount(int nb) {
        this.nb_ = nb;
    }

    public int getForecastsCount() {
        return this.nf_;
    }

    public void setForecastsCount(int nf) {
        this.nf_ = nf;
    }

    public TsSmoothingSpecification clone() {
        try {
            TsSmoothingSpecification spec = (TsSmoothingSpecification)super.clone();
            if (this.param_ != null) {
                spec.param_ = this.param_.clone();
            }
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        info.add("algorithm", (Object)TsSmoothingProcessor.DESCRIPTOR);
        if (this.cnt_ || verbose) {
            info.add(CNT, (Object)this.cnt_);
        }
        if (this.trend_ || verbose) {
            info.add(TREND, (Object)this.trend_);
        }
        if (!Parameter.isDefault((Parameter)this.param_)) {
            info.add(PARAM, (Object)this.param_);
        }
        info.add(TYPE, (Object)this.type_.name());
        info.add(MODEL, (Object)this.model_.name());
        info.add(NFREQ, (Object)this.nfreq_.intValue());
        if (this.nb_ != 0 || verbose) {
            info.add(NB, (Object)this.nb_);
        }
        if (this.nf_ != 0 || verbose) {
            info.add(NF, (Object)this.nf_);
        }
        return info;
    }

    public boolean read(InformationSet info) {
        Integer f;
        String s;
        Parameter p;
        Boolean b = (Boolean)info.get(CNT, Boolean.class);
        if (b != null) {
            this.cnt_ = b;
        }
        if ((b = (Boolean)info.get(TREND, Boolean.class)) != null) {
            this.trend_ = b;
        }
        if ((p = (Parameter)info.get(PARAM, Parameter.class)) != null) {
            this.param_ = p;
        }
        if ((s = (String)info.get(TYPE, String.class)) != null) {
            this.type_ = TsAggregationType.valueOf((String)s);
        }
        if ((s = (String)info.get(MODEL, String.class)) != null) {
            this.model_ = TsExpander.Model.valueOf((String)s);
        }
        if ((f = (Integer)info.get(NFREQ, Integer.class)) == null) {
            return false;
        }
        this.nfreq_ = TsFrequency.valueOf((int)f);
        Integer n = (Integer)info.get(NB, Integer.class);
        if (n != null) {
            this.nb_ = n;
        }
        if ((n = (Integer)info.get(NF, Integer.class)) != null) {
            this.nf_ = n;
        }
        return true;
    }

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item((String)prefix, (String)CNT), Boolean.class);
        dic.put(InformationSet.item((String)prefix, (String)TREND), Boolean.class);
        dic.put(InformationSet.item((String)prefix, (String)PARAM), Parameter.class);
        dic.put(InformationSet.item((String)prefix, (String)MODEL), String.class);
        dic.put(InformationSet.item((String)prefix, (String)TYPE), String.class);
        dic.put(InformationSet.item((String)prefix, (String)NFREQ), Integer.class);
        dic.put(InformationSet.item((String)prefix, (String)NB), Integer.class);
        dic.put(InformationSet.item((String)prefix, (String)NF), Integer.class);
    }
}

