/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.disaggregation.documents;

import ec.tss.disaggregation.documents.CholetteSpecification;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.Map;

public class UniCholetteSpecification
extends CholetteSpecification
implements Cloneable {
    public static final String FREQ = "freq";
    public static final String TYPE = "type";
    private TsFrequency agg_ = TsFrequency.Undefined;
    private TsAggregationType type_ = TsAggregationType.Average;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Cholette ");
        builder.append(" (rho=").append(this.getRho()).append(", lambda=").append(this.getLambda()).append(')');
        return builder.toString();
    }

    @Override
    public UniCholetteSpecification clone() {
        return (UniCholetteSpecification)super.clone();
    }

    public boolean equals(UniCholetteSpecification other) {
        return super.equals(other) && this.agg_ == other.agg_ && this.type_ == other.type_;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof UniCholetteSpecification && this.equals((UniCholetteSpecification)obj);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 67 * hash + (this.getAggregationFrequency() != null ? this.getAggregationFrequency().hashCode() : 0);
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet info = super.write(verbose);
        if (info == null) {
            return null;
        }
        info.set(FREQ, (Object)this.agg_.intValue());
        info.set(TYPE, (Object)this.type_.name());
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        String t;
        if (!super.read(info)) {
            return false;
        }
        Integer f = (Integer)info.get(FREQ, Integer.class);
        if (f != null) {
            this.agg_ = TsFrequency.valueOf((int)f);
        }
        if ((t = (String)info.get(TYPE, String.class)) != null) {
            this.type_ = TsAggregationType.valueOf((String)t);
        }
        return true;
    }

    public TsFrequency getAggregationFrequency() {
        return this.agg_;
    }

    public void setAggregationFrequency(TsFrequency agg) {
        this.agg_ = agg;
    }

    public TsAggregationType getAggregationType() {
        return this.type_;
    }

    public void setAggregationType(TsAggregationType type) {
        this.type_ = type;
    }

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        CholetteSpecification.fillDictionary(prefix, dic);
        dic.put(FREQ, Integer.class);
        dic.put(TYPE, String.class);
    }
}

