/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.disaggregation.processors;

import ec.benchmarking.simplets.Calendarization;
import ec.tss.disaggregation.documents.CalendarizationResults;
import ec.tss.disaggregation.documents.CalendarizationSpecification;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CalendarizationProcessor
implements IProcessingFactory<CalendarizationSpecification, List<Calendarization.PeriodObs>, CalendarizationResults> {
    public static final String FAMILY = "Benchmarking";
    public static final AlgorithmDescriptor DESCRIPTOR = new AlgorithmDescriptor("Benchmarking", "Calendarization", null);
    public static final CalendarizationProcessor instance = new CalendarizationProcessor();

    public void dispose() {
    }

    public AlgorithmDescriptor getInformation() {
        return DESCRIPTOR;
    }

    public boolean canHandle(IProcSpecification spec) {
        return spec instanceof CalendarizationSpecification;
    }

    public IProcessing<List<Calendarization.PeriodObs>, CalendarizationResults> generateProcessing(CalendarizationSpecification specification, ProcessingContext context) {
        return new DefaultProcessing(specification);
    }

    public Map<String, Class> getSpecificationDictionary(Class<CalendarizationSpecification> specClass) {
        HashMap<String, Class> dic = new HashMap<String, Class>();
        CalendarizationSpecification.fillDictionary(null, dic);
        return dic;
    }

    public Map<String, Class> getOutputDictionary(boolean compact) {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        CalendarizationResults.fillDictionary(null, dic, compact);
        return dic;
    }

    public static class DefaultProcessing
    implements IProcessing<List<Calendarization.PeriodObs>, CalendarizationResults> {
        private final CalendarizationSpecification spec;

        public DefaultProcessing(CalendarizationSpecification spec) {
            this.spec = spec.clone();
        }

        public CalendarizationResults process(List<Calendarization.PeriodObs> input) {
            CalendarizationResults rslts = new CalendarizationResults();
            Calendarization cal = new Calendarization();
            for (Calendarization.PeriodObs p : input) {
                cal.add(p.start, p.end, p.value);
            }
            cal.setDailyWeights(this.spec.getWeights());
            TsFrequency freq = this.spec.getAggFrequency();
            TsPeriod end = new TsPeriod(freq);
            end.set(input.get((int)(input.size() - 1)).end);
            cal.setSpan(input.get((int)0).start, end.lastday());
            TsData agg = cal.getAggregates(freq);
            TsData aggStdev = cal.getAggregatesStdev(freq);
            double[] smooth = cal.getSmoothedData();
            double[] smoothStdev = cal.getSmoothedStdev();
            rslts.set(smooth, smoothStdev, agg, aggStdev);
            return rslts;
        }
    }
}

