/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.disaggregation.processors;

import ec.benchmarking.simplets.TsCholette;
import ec.tss.disaggregation.documents.BenchmarkingResults;
import ec.tss.disaggregation.documents.UniCholetteSpecification;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class CholetteProcessor
implements IProcessingFactory<UniCholetteSpecification, TsData[], BenchmarkingResults> {
    public static final String FAMILY = "Benchmarking";
    public static final AlgorithmDescriptor DESCRIPTOR = new AlgorithmDescriptor("Benchmarking", "Cholette", null);
    public static final CholetteProcessor instance = new CholetteProcessor();

    protected CholetteProcessor() {
    }

    public void dispose() {
    }

    public AlgorithmDescriptor getInformation() {
        return DESCRIPTOR;
    }

    public boolean canHandle(IProcSpecification spec) {
        return spec instanceof UniCholetteSpecification;
    }

    public IProcessing<TsData[], BenchmarkingResults> generateProcessing(UniCholetteSpecification spec, ProcessingContext context) {
        return new DefaultProcessing(spec);
    }

    public IProcessing<TsData[], BenchmarkingResults> generateProcessing(UniCholetteSpecification spec) {
        return new DefaultProcessing(spec);
    }

    public Map<String, Class> getSpecificationDictionary(Class<UniCholetteSpecification> specClass) {
        HashMap<String, Class> dic = new HashMap<String, Class>();
        UniCholetteSpecification.fillDictionary(null, dic);
        return dic;
    }

    public Map<String, Class> getOutputDictionary(boolean compact) {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        BenchmarkingResults.fillDictionary(null, dic, compact);
        return dic;
    }

    public static class DefaultProcessing
    implements IProcessing<TsData[], BenchmarkingResults> {
        private final UniCholetteSpecification spec;

        public DefaultProcessing(UniCholetteSpecification spec) {
            this.spec = spec.clone();
        }

        public BenchmarkingResults process(TsData[] input) {
            TsData s = input[0];
            TsData c = input[1];
            BenchmarkingResults rslts = new BenchmarkingResults();
            if (s != null && c != null) {
                TsCholette cholette = new TsCholette();
                cholette.setRho(this.spec.getRho());
                cholette.setLambda(this.spec.getLambda());
                TsFrequency agg = this.spec.getAggregationFrequency();
                if (agg != TsFrequency.Undefined && s.getFrequency().intValue() > agg.intValue()) {
                    s = s.changeFrequency(agg, this.spec.getAggregationType(), true);
                }
                cholette.setAggregationType(this.spec.getAggregationType());
                TsData bench = cholette.process(s, c);
                rslts.set(s, input[1], bench);
            }
            return rslts;
        }
    }
}

