/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.disaggregation.processors;

import ec.benchmarking.denton.DentonMethod;
import ec.tss.disaggregation.documents.BenchmarkingResults;
import ec.tss.disaggregation.documents.DentonSpecification;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class DentonProcessor
implements IProcessingFactory<DentonSpecification, TsData[], BenchmarkingResults> {
    public static final String FAMILY = "Benchmarking";
    public static final AlgorithmDescriptor DESCRIPTOR = new AlgorithmDescriptor("Benchmarking", "Denton", null);
    public static final DentonProcessor instance = new DentonProcessor();

    public void dispose() {
    }

    public AlgorithmDescriptor getInformation() {
        return DESCRIPTOR;
    }

    public boolean canHandle(IProcSpecification spec) {
        return spec instanceof DentonSpecification;
    }

    public IProcessing<TsData[], BenchmarkingResults> generateProcessing(DentonSpecification specification, ProcessingContext context) {
        return new DefaultProcessing(specification);
    }

    public Map<String, Class> getSpecificationDictionary(Class<DentonSpecification> specClass) {
        HashMap<String, Class> dic = new HashMap<String, Class>();
        DentonSpecification.fillDictionary(null, dic);
        return dic;
    }

    public Map<String, Class> getOutputDictionary(boolean compact) {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        BenchmarkingResults.fillDictionary(null, dic, compact);
        return dic;
    }

    public static class DefaultProcessing
    implements IProcessing<TsData[], BenchmarkingResults> {
        private final DentonSpecification spec;

        public DefaultProcessing(DentonSpecification spec) {
            this.spec = spec.clone();
        }

        public BenchmarkingResults process(TsData[] input) {
            TsData q = input[0];
            TsData Y = input[1];
            BenchmarkingResults rslts = new BenchmarkingResults();
            if (Y != null) {
                TsData tr;
                int qfreq;
                DentonMethod denton = new DentonMethod();
                denton.setAggregationType(this.spec.getAggregationType());
                denton.setDifferencingOrder(this.spec.getDifferencingOrder());
                denton.setMultiplicative(this.spec.isMultiplicative());
                denton.setModifiedDenton(this.spec.isModifiedDenton());
                int yfreq = Y.getFrequency().intValue();
                int n = qfreq = q != null ? q.getFrequency().intValue() : this.spec.getDefaultFrequency().intValue();
                if (qfreq % yfreq != 0) {
                    return null;
                }
                denton.setConversionFactor(qfreq / yfreq);
                if (q != null) {
                    TsPeriodSelector qsel = new TsPeriodSelector();
                    qsel.between(q.getStart().firstday(), q.getLastPeriod().lastday());
                    Y = Y.select(qsel);
                    TsPeriod q0 = q.getStart();
                    TsPeriod yq0 = new TsPeriod(q0.getFrequency());
                    yq0.set(Y.getStart().firstday());
                    denton.setOffset(yq0.minus(q0));
                    double[] r = denton.process((IReadDataBlock)q, (IReadDataBlock)Y);
                    tr = new TsData(q.getStart(), r, false);
                } else {
                    TsPeriod qstart = Y.getStart().firstPeriod(this.spec.getDefaultFrequency());
                    double[] r = denton.process((IReadDataBlock)Y);
                    tr = new TsData(qstart, r, false);
                }
                rslts.set(input[0], input[1], tr);
            }
            return rslts;
        }
    }
}

