/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.disaggregation.processors;

import ec.benchmarking.DisaggregationModel;
import ec.benchmarking.simplets.TsDisaggregation;
import ec.tss.disaggregation.documents.DisaggregationResults;
import ec.tss.disaggregation.documents.DisaggregationSpecification;
import ec.tss.disaggregation.processors.ITemporalDisaggregationProcessingFactory;
import ec.tstoolkit.Parameter;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.polynomials.UnitRoots;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.arima.SsfAr1;
import ec.tstoolkit.ssf.arima.SsfArima;
import ec.tstoolkit.ssf.arima.SsfRw;
import ec.tstoolkit.ssf.arima.SsfRwAr1;
import ec.tstoolkit.timeseries.regression.Constant;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.LinearTrend;
import ec.tstoolkit.timeseries.regression.TsVariable;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.Map;

public class DisaggregationProcessor
implements ITemporalDisaggregationProcessingFactory,
IProcessingFactory<DisaggregationSpecification, TsData[], DisaggregationResults> {
    public static final String NAME = "Regression-based disaggregation";
    public static final AlgorithmDescriptor DESCRIPTOR = new AlgorithmDescriptor("Temporal Disaggregation", "Regression-based disaggregation", null);
    public static final DisaggregationProcessor instance = new DisaggregationProcessor();

    protected DisaggregationProcessor() {
    }

    public void dispose() {
    }

    public AlgorithmDescriptor getInformation() {
        return DESCRIPTOR;
    }

    public boolean canHandle(IProcSpecification spec) {
        return spec instanceof DisaggregationSpecification;
    }

    public IProcessing<TsData[], DisaggregationResults> generateProcessing(DisaggregationSpecification spec, ProcessingContext context) {
        return new DefaultProcessing(spec);
    }

    public IProcessing<TsData[], DisaggregationResults> generateProcessing(DisaggregationSpecification spec) {
        return new DefaultProcessing(spec);
    }

    public Map<String, Class> getSpecificationDictionary(Class<DisaggregationSpecification> specClass) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<String, Class> getOutputDictionary(boolean compact) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static class DefaultProcessing
    implements IProcessing<TsData[], DisaggregationResults> {
        private final DisaggregationSpecification spec;

        public DefaultProcessing(DisaggregationSpecification spec) {
            this.spec = spec.clone();
        }

        public DisaggregationResults process(TsData[] input) {
            DisaggregationModel model = this.prepare(input, this.spec.getDefaultFrequency());
            if (model == null) {
                return null;
            }
            Object disagg = this.spec.getModel() == DisaggregationSpecification.Model.Ar1 ? this.initChowLin() : (this.spec.getModel() == DisaggregationSpecification.Model.Wn ? this.initOLS() : (this.spec.getModel() == DisaggregationSpecification.Model.RwAr1 ? this.initLitterman() : (this.spec.getModel() == DisaggregationSpecification.Model.Rw ? this.initFernandez() : this.initI(this.spec.getModel().getDifferencingOrder()))));
            disagg.useML(this.spec.isML());
            disagg.calculateVariance(true);
            disagg.setSsfOption(this.spec.getOption());
            if (this.spec.isDiffuseRegression()) {
                disagg.setDiffuseRegressorsCount(model.getX().getVariablesCount());
            }
            if (!disagg.process(model, null)) {
                return null;
            }
            int n = model.getX().getVariablesCount();
            if (this.spec.isConstant()) {
                --n;
            }
            if (this.spec.isTrend()) {
                --n;
            }
            return new DisaggregationResults((TsDisaggregation<? extends ISsf>)disagg, n);
        }

        private TsDisaggregation<SsfAr1> initChowLin() {
            TsDisaggregation disagg = new TsDisaggregation();
            SsfAr1 ssf = new SsfAr1();
            Parameter p = this.spec.getParameter();
            if (p != null && p.isFixed()) {
                ssf.setRho(p.getValue());
            } else {
                disagg.setMapping((IParametricMapping)new SsfAr1.Mapping(this.spec.isZeroInitialization(), this.spec.getTruncatedRho(), 1.0));
            }
            ssf.useZeroInitialization(this.spec.isZeroInitialization());
            disagg.setSsf((ISsf)ssf);
            return disagg;
        }

        private TsDisaggregation<SsfAr1> initOLS() {
            TsDisaggregation disagg = new TsDisaggregation();
            SsfAr1 ssf = new SsfAr1();
            ssf.setRho(0.0);
            disagg.setSsf((ISsf)ssf);
            return disagg;
        }

        private TsDisaggregation<SsfRwAr1> initLitterman() {
            TsDisaggregation disagg = new TsDisaggregation();
            SsfRwAr1 ssf = new SsfRwAr1();
            Parameter p = this.spec.getParameter();
            if (p != null && p.isFixed()) {
                ssf.setRho(p.getValue());
            } else {
                disagg.setMapping((IParametricMapping)new SsfRwAr1.Mapping(this.spec.isZeroInitialization(), this.spec.getTruncatedRho(), 1.0));
            }
            ssf.useZeroInitialization(this.spec.isZeroInitialization());
            disagg.setSsf((ISsf)ssf);
            return disagg;
        }

        private TsDisaggregation<SsfRw> initFernandez() {
            TsDisaggregation disagg = new TsDisaggregation();
            SsfRw ssf = new SsfRw();
            ssf.useZeroInitialization(this.spec.isZeroInitialization());
            disagg.setSsf((ISsf)ssf);
            return disagg;
        }

        private TsDisaggregation<SsfArima> initI(int diff) {
            TsDisaggregation disagg = new TsDisaggregation();
            ArimaModel sarima = new ArimaModel(null, new BackFilter(UnitRoots.D((int)1, (int)diff)), null, 1.0);
            SsfArima ssf = new SsfArima((IArimaModel)sarima);
            disagg.setSsf((ISsf)ssf);
            return disagg;
        }

        private DisaggregationModel prepare(TsData[] input, TsFrequency def) {
            if (input == null || input.length == 0) {
                return null;
            }
            TsData y = input[0].select(this.spec.getSpan());
            DisaggregationModel model = new DisaggregationModel(def);
            model.setY(y);
            if (input.length == 1) {
                if (def == TsFrequency.Undefined || !y.getFrequency().contains(def)) {
                    return null;
                }
                model.setDefaultForecastCount(def.intValue());
            }
            TsVariableList x = new TsVariableList();
            if (this.spec.isConstant() && (this.spec.getModel().isStationary() || this.spec.isZeroInitialization())) {
                x.add((ITsVariable)new Constant());
            }
            if (this.spec.isTrend()) {
                x.add((ITsVariable)new LinearTrend(input[0].getStart().firstday()));
            }
            for (int i = 1; i < input.length; ++i) {
                x.add((ITsVariable)new TsVariable("var-" + i, input[i]));
            }
            if (!x.isEmpty()) {
                model.setX(x);
            }
            model.setAggregationType(this.spec.getType());
            return model;
        }
    }
}

